/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.definition.InterfaceDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.model.XModelObject;

public class CDISeamSolderServiceHandlerExtension
implements ICDIExtension,
IBuildParticipantFeature {
    ServiceHandlerDefinitionContext context = new ServiceHandlerDefinitionContext();

    protected Version getVersion() {
        return Version.instance;
    }

    public IDefinitionContextExtension getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
        ServiceHandlerDefinitionContext workingCopy = (ServiceHandlerDefinitionContext)this.context.getWorkingCopy();
        Map is = fileSet.getInterfaces();
        for (IPath path : is.keySet()) {
            for (IType t : (List)is.get(path)) {
                InterfaceDefinition i = new InterfaceDefinition(t, (IDefinitionContextExtension)workingCopy);
                List as = i.getAnnotations();
                for (IAnnotationDeclaration a : as) {
                    if (!workingCopy.isServiceAnnotation(a.getType())) continue;
                    TypeDefinition d = new TypeDefinition();
                    d.setType(t, workingCopy.getRootContext(), 0);
                    d.setBeanConstructor(true);
                    workingCopy.addService(path, d);
                }
            }
        }
    }

    public void buildBeans(CDIProject target) {
        CDIProject p = target;
        Map<String, TypeDefinition> services = this.context.getServices();
        for (TypeDefinition d : services.values()) {
            ClassBean b = new ClassBean();
            b.setDefinition(d);
            b.setParent((ICDIElement)p);
            p.addBean((IBean)b);
        }
    }

    class ServiceHandlerDefinitionContext
    extends AbstractDefinitionContextExtension {
        Set<String> serviceAnnotations = new HashSet<String>();
        Map<String, TypeDefinition> services = new HashMap<String, TypeDefinition>();

        ServiceHandlerDefinitionContext() {
        }

        protected ServiceHandlerDefinitionContext copy(boolean clean) {
            ServiceHandlerDefinitionContext copy = new ServiceHandlerDefinitionContext();
            copy.root = this.root;
            if (!clean) {
                for (String qn : this.services.keySet()) {
                    TypeDefinition d = this.services.get(qn);
                    if (!d.exists()) continue;
                    copy.services.put(qn, d);
                }
                copy.serviceAnnotations.addAll(this.serviceAnnotations);
            }
            return copy;
        }

        protected void doApplyWorkingCopy() {
            this.services = ((ServiceHandlerDefinitionContext)this.workingCopy).services;
            this.serviceAnnotations = ((ServiceHandlerDefinitionContext)this.workingCopy).serviceAnnotations;
        }

        public void clean() {
            this.services.clear();
            this.serviceAnnotations.clear();
        }

        public void clean(String typeName) {
            this.services.remove(typeName);
            this.serviceAnnotations.remove(typeName);
        }

        public void addService(IPath path, TypeDefinition def) {
            String typeName = def.getType().getFullyQualifiedName();
            this.services.put(typeName, def);
            this.root.addType(path, typeName);
        }

        public Map<String, TypeDefinition> getServices() {
            return this.services;
        }

        public void computeAnnotationKind(AnnotationDefinition annotation) {
            if (annotation.isAnnotationPresent(CDISeamSolderServiceHandlerExtension.this.getVersion().getHandlerTypeAnnotationTypeName())) {
                annotation.setExtendedKind((Object)"serviceAnnotation");
                this.serviceAnnotations.add(annotation.getType().getFullyQualifiedName());
            }
        }

        public boolean isServiceAnnotation(IType type) {
            return type != null && this.serviceAnnotations.contains(type.getFullyQualifiedName());
        }
    }
}

