/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerField;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IAmbiguousBeanResolverFeature;
import org.jboss.tools.cdi.core.extension.feature.IBeanKeyProvider;
import org.jboss.tools.cdi.core.extension.feature.IBeanStoreFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanMember;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeanMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderCorePlugin;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderPreferences;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.validation.SeamSolderValidationMessages;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.java.impl.AnnotationLiteral;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;

public class CDISeamSolderDefaultBeanExtension
implements ICDIExtension,
IProcessAnnotatedTypeFeature,
IAmbiguousBeanResolverFeature,
IValidatorFeature,
IBeanKeyProvider,
IBeanStoreFeature {
    private static String ID = "org.jboss.solder.bean.defaultbean.DefaultBeanExtension";
    private static String ID_30 = "org.jboss.seam.solder.bean.defaultbean.DefaultBeanExtension";
    protected Map<String, Set<IBean>> defaultBeansByKey = new HashMap<String, Set<IBean>>();

    public static CDISeamSolderDefaultBeanExtension getExtension(CDICoreNature project) {
        ICDIExtension result = project.getExtensionManager().getExtensionByRuntime(ID);
        if (result == null) {
            result = project.getExtensionManager().getExtensionByRuntime(ID_30);
        }
        if (result instanceof CDISeamSolderDefaultBeanExtension) {
            return (CDISeamSolderDefaultBeanExtension)result;
        }
        return null;
    }

    protected Version getVersion() {
        return Version.instance;
    }

    public void processAnnotatedType(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        String defaultBeanAnnotationTypeName = this.getVersion().getDefaultBeanAnnotationTypeName();
        boolean defaultBean = typeDefinition.isAnnotationPresent(defaultBeanAnnotationTypeName);
        IJavaAnnotation beanTyped = null;
        if (defaultBean && (beanTyped = this.createFakeTypedAnnotation((AbstractMemberDefinition)typeDefinition, context)) != null) {
            typeDefinition.addAnnotation(beanTyped, context);
        }
        List ms = typeDefinition.getMethods();
        for (MethodDefinition m : ms) {
            IJavaAnnotation methodTyped;
            if (!m.isAnnotationPresent("javax.enterprise.inject.Produces") || !defaultBean && !m.isAnnotationPresent(defaultBeanAnnotationTypeName) || (methodTyped = this.createFakeTypedAnnotation((AbstractMemberDefinition)m, context)) == null) continue;
            m.addAnnotation(methodTyped, context);
        }
        List fs = typeDefinition.getFields();
        for (FieldDefinition f : fs) {
            IJavaAnnotation fieldTyped;
            if (!f.isAnnotationPresent("javax.enterprise.inject.Produces") || !defaultBean && !f.isAnnotationPresent(defaultBeanAnnotationTypeName) || (fieldTyped = this.createFakeTypedAnnotation((AbstractMemberDefinition)f, context)) == null) continue;
            f.addAnnotation(fieldTyped, context);
        }
    }

    IJavaAnnotation createFakeTypedAnnotation(AbstractMemberDefinition def, IRootDefinitionContext context) {
        IType typedAnnotation;
        TypeDeclaration type;
        AnnotationLiteral result = null;
        AnnotationDeclaration a = def.getAnnotation(this.getVersion().getDefaultBeanAnnotationTypeName());
        if (a != null) {
            Object n = a.getMemberValue(null);
            if (n != null && n.toString().length() > 0) {
                String defaultType = n.toString();
                IType typedAnnotation2 = context.getProject().getType("javax.enterprise.inject.Typed");
                if (typedAnnotation2 != null) {
                    result = new AnnotationLiteral(def.getResource(), a.getStartPosition(), a.getLength(), (Object)defaultType, 11, typedAnnotation2);
                }
            }
        } else if (def instanceof BeanMemberDefinition && (type = BeanMember.getTypeDeclaration((AbstractMemberDefinition)def, (ParametedTypeFactory)context.getProject().getTypeFactory())) != null && (typedAnnotation = context.getProject().getType("javax.enterprise.inject.Typed")) != null) {
            result = new AnnotationLiteral(def.getResource(), type.getStartPosition(), type.getLength(), (Object)type.getType().getFullyQualifiedName(), 11, typedAnnotation);
        }
        return result;
    }

    public Collection<IBean> getResolvedBeans(Collection<IBean> result) {
        HashSet<IBean> defaultBeans = new HashSet<IBean>();
        for (IBean b : result) {
            if (!this.isBeanDefault(b)) continue;
            defaultBeans.add(b);
        }
        if (!defaultBeans.isEmpty() && defaultBeans.size() < result.size()) {
            result.removeAll(defaultBeans);
        }
        return result;
    }

    public boolean isBeanDefault(IBean bean) {
        IProducer producer;
        IClassBean parent;
        String defaultBeanAnnotationTypeName = this.getVersion().getDefaultBeanAnnotationTypeName();
        if (bean.isAnnotationPresent(defaultBeanAnnotationTypeName)) {
            return true;
        }
        return bean instanceof IProducer && (parent = (producer = (IProducer)bean).getClassBean()) != null && parent.isAnnotationPresent(defaultBeanAnnotationTypeName);
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        String defaultBeanAnnotationTypeName = this.getVersion().getDefaultBeanAnnotationTypeName();
        ICDIProject cdiProject = CDICorePlugin.getCDIProject((IProject)file.getProject(), (boolean)true);
        if (cdiProject == null) {
            return;
        }
        for (IBean bean : cdiProject.getBeans(file.getFullPath())) {
            IClassBean cb;
            IScope scope;
            if (!this.isBeanDefault(bean)) continue;
            IAnnotationDeclaration a = bean.getAnnotation(defaultBeanAnnotationTypeName);
            if (a == null) {
                Collection ds = bean.getAllTypeDeclarations();
                if (ds.isEmpty()) continue;
                IType e = bean instanceof IJavaReference ? ((IJavaReference)bean).getSourceMember() : bean.getBeanClass();
                a = CDIUtil.convertToJavaSourceReference((ITextSourceReference)((ITextSourceReference)ds.iterator().next()), (IMember)e);
            }
            if (bean instanceof IProducerField && (scope = (cb = ((IProducerField)bean).getClassBean()).getScope()) != null && scope.isNorlmalScope()) {
                validator.addError(SeamSolderValidationMessages.DEFAULT_PRODUCER_FIELD_ON_NORMAL_SCOPED_BEAN, CDISeamSolderPreferences.DEFAULT_PRODUCER_FIELD_ON_NORMAL_SCOPED_BEAN, new String[0], (ITextSourceReference)a, (IResource)file);
            }
            IQualifierDeclaration[] qs = bean.getQualifierDeclarations().toArray(new IQualifierDeclaration[0]);
            IParametedType type = this.getDefaultType(bean);
            if (type == null) continue;
            String key = this.createKey(type, bean.getQualifierDeclarations(true));
            Set<IBean> linked = this.defaultBeansByKey.get(key);
            if (linked != null) {
                for (IBean link : linked) {
                    if (link.getSourcePath() == null) continue;
                    validator.getValidationContext().addLinkedCoreResource("jboss.cdi.core", key, link.getSourcePath(), true);
                }
            }
            StringBuilder otherDefaultBeans = new StringBuilder();
            for (IBean b : cdiProject.getBeans(false, type, qs)) {
                try {
                    if (b == bean || !this.isBeanDefault(b) || !CDIProject.areMatchingQualifiers((Collection)bean.getQualifierDeclarations(), (Collection)b.getQualifierDeclarations(true))) continue;
                    if (otherDefaultBeans.length() > 0) {
                        otherDefaultBeans.append(", ");
                    }
                    otherDefaultBeans.append(b.getElementName());
                }
                catch (CoreException e) {
                    CDISeamSolderCorePlugin.getDefault().logError(e);
                }
            }
            if (otherDefaultBeans.length() <= 0) continue;
            String message = NLS.bind((String)SeamSolderValidationMessages.IDENTICAL_DEFAULT_BEANS, (Object)otherDefaultBeans);
            validator.addError(message, CDISeamSolderPreferences.IDENTICAL_DEFAULT_BEANS, new String[0], (ITextSourceReference)a, (IResource)file);
        }
    }

    public SeverityPreferences getSeverityPreferences() {
        return CDISeamSolderPreferences.getInstance();
    }

    private IParametedType getDefaultType(IBean bean) {
        Collection ts = bean.getLegalTypes();
        if (ts.size() < 3) {
            for (IParametedType t : ts) {
                if ("java.lang.Object".equals(t.getType().getFullyQualifiedName())) continue;
                return t;
            }
        }
        return null;
    }

    public String getKey(IBean bean) {
        IParametedType type;
        if (this.isBeanDefault(bean) && (type = this.getDefaultType(bean)) != null) {
            return this.createKey(type, bean.getQualifierDeclarations(true));
        }
        return null;
    }

    private String createKey(IParametedType type, Collection<IQualifierDeclaration> qs) {
        TreeSet<String> ss = new TreeSet<String>();
        for (IQualifierDeclaration q : qs) {
            if (q.getTypeName().equals("javax.enterprise.inject.Any") || q.getTypeName().equals("javax.enterprise.inject.Default")) continue;
            ss.add(q.getTypeName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#DefaultBean_").append(type.getType().getFullyQualifiedName());
        for (String s : ss) {
            sb.append(':').append(s);
        }
        return sb.toString();
    }

    public synchronized void updateCaches(ICDIProject project) {
        IBean[] beans;
        HashMap<String, Set<IBean>> map = new HashMap<String, Set<IBean>>();
        IBean[] iBeanArray = beans = project.getBeans();
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            IBean b = iBeanArray[n2];
            String key = this.getKey(b);
            if (key != null) {
                HashSet<IBean> bs = (HashSet<IBean>)map.get(key);
                if (bs == null) {
                    bs = new HashSet<IBean>();
                    map.put(key, bs);
                }
                bs.add(b);
            }
            ++n2;
        }
        this.defaultBeansByKey = map;
    }
}

