/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.ui.pages.editor.PagesEditor;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.edit.PageEditPart;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.xpl.FixedConnectionAnchor;

public class PageFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 100);
    private static final Color backgroundColor = new Color(null, 255, 247, 203);
    private static final Color foregroundColor = new Color(null, 157, 150, 36);
    private static final Color greyBackground = new Color(null, 241, 241, 241);
    private static final Color greyForeground = new Color(null, 153, 149, 153);
    private static final Color borderColor = new Color(null, 173, 169, 173);
    private static final Image pageImage = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/ico_page.png").createImage();
    private static final Image plusImage = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/ico_plus.png").createImage();
    private static final Image minusImage = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/ico_minus.png").createImage();
    private static final Image crossImage = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/ico_cross.gif").createImage();
    public Page page;
    String path;
    PageEditPart editPart;

    public void setPageEditPart(PageEditPart part) {
        this.editPart = part;
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void setIcon(Image i) {
    }

    public PageFigure(Page page) {
        this.page = page;
        if (page != null && page.getData() != null) {
            this.setIcon(page.getImage());
            this.initConnectionAnchors(page.getOutputLinks().size());
        }
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder((Border)new PageBorder(ColorConstants.black));
        if (page != null) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 10;
            c.offsetH = -8;
            this.connectionAnchors.put("1_IN", c);
            this.inputConnectionAnchors.addElement(c);
        }
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor anchor = (ConnectionAnchor)this.connectionAnchors.get(terminal);
        while (anchor == null) {
            this.addConnectionAnchor(this.outputConnectionAnchors.size());
            anchor = (ConnectionAnchor)this.connectionAnchors.get(terminal);
        }
        return anchor;
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int height = r.height - 1;
        if (this.page != null) {
            if (this.page.isConfirmed()) {
                g.setBackgroundColor(backgroundColor);
                g.setForegroundColor(foregroundColor);
            } else {
                g.setBackgroundColor(greyBackground);
                g.setForegroundColor(greyForeground);
            }
        } else {
            g.setBackgroundColor(greyBackground);
            g.setForegroundColor(greyForeground);
        }
        Rectangle boundingRect = new Rectangle(1, 1, r.width, r.height);
        g.fillRectangle(boundingRect);
        g.drawImage(pageImage, 1, 1);
        if (this.page != null && this.page.getData() != null && SeamPagesDiagramStructureHelper.instance.isUnconfirmedPage((XModelObject)this.page.getData())) {
            g.drawImage(crossImage, this.getInsetX() - 1, this.getInsetY() + 4);
        }
        if (this.page != null && this.page.getName() != null) {
            g.setFont(nodeLabelFont);
            g.drawString(this.page.getName(), 27, 3);
        }
        if (!this.page.getChildren().isEmpty()) {
            if (this.page.isParamsVisible()) {
                g.drawImage(minusImage, 4, height - 12);
            } else {
                g.drawImage(plusImage, 4, height - 12);
            }
        }
    }

    private int getInsetY() {
        return 2;
    }

    private int getInsetX() {
        return 4;
    }

    class PageBorder
    extends LineBorder {
        public PageBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = PageBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            if (PageFigure.this.page != null) {
                graphics.setForegroundColor(foregroundColor);
            } else {
                graphics.setForegroundColor(greyForeground);
            }
            if (PageFigure.this.page != null && !PageFigure.this.page.isConfirmed()) {
                graphics.setLineDash(new int[]{3, 3});
                graphics.setLineStyle(6);
                graphics.setForegroundColor(borderColor);
            }
            graphics.drawLine(1, 0, width - 1, 0);
            graphics.drawLine(0, 1, 0, height - 1);
            graphics.drawLine(1, height, width - 1, height);
            graphics.drawLine(width, 1, width, height - 1);
        }
    }
}

