/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.seam.ui.pages.editor.PagesEditor;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PageException;
import org.jboss.tools.seam.ui.pages.editor.edit.ExceptionEditPart;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.xpl.CompressNameUtil;
import org.jboss.tools.seam.ui.pages.editor.figures.xpl.FixedConnectionAnchor;

public class ExceptionFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 100);
    private static final Color exceptionBackgroundColor = new Color(null, 234, 243, 255);
    private static final Color exceptionForegroundColor = new Color(null, 65, 119, 160);
    private static final Color borderColor = new Color(null, 103, 127, 145);
    private static final Color greyForeground = new Color(null, 153, 149, 153);
    private static final Image exceptionImage = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/ico_exception.png").createImage();
    public PageException exc;
    ExceptionEditPart editPart;
    int width;
    int height;

    public void setEditPart(ExceptionEditPart part) {
        this.editPart = part;
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void setIcon(Image i) {
    }

    public ExceptionFigure(PageException group) {
        this.exc = group;
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder((Border)new GroupBorder(ColorConstants.black));
        if (group != null) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 10;
            c.offsetH = -1;
            c.leftToRight = false;
            this.connectionAnchors.put("1_OUT", c);
            this.outputConnectionAnchors.addElement(c);
        }
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        if (this.exc != null) {
            g.setBackgroundColor(exceptionBackgroundColor);
            g.setForegroundColor(exceptionForegroundColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        Rectangle boundingRect = new Rectangle(1, 1, r.width, r.height);
        g.fillRectangle(boundingRect);
        g.drawImage(exceptionImage, 1, 1);
        if (this.exc != null) {
            g.setFont(nodeLabelFont);
            g.drawString(this.getExceptionReadOnlyLabel(), 27, 3);
        }
    }

    String getExceptionReadOnlyLabel() {
        if (this.exc == null || this.exc.getName() == null) {
            return "Unknown Exception";
        }
        return CompressNameUtil.getCompressedName(this.exc.getName());
    }

    class GroupBorder
    extends LineBorder {
        public GroupBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = GroupBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            if (ExceptionFigure.this.exc != null) {
                graphics.setForegroundColor(borderColor);
            } else {
                graphics.setForegroundColor(greyForeground);
            }
            graphics.drawLine(1, 0, width - 1, 0);
            graphics.drawLine(0, 1, 0, height - 1);
            graphics.drawLine(1, height, width - 1, height);
            graphics.drawLine(width, 1, width, height - 1);
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (me.button == 3) {
                ((GEFGraphicalViewer)ExceptionFigure.this.editPart.getViewer()).setNoDeselect();
                ExceptionFigure.this.editPart.getViewer().select((EditPart)ExceptionFigure.this.editPart);
            }
        }
    }
}

