/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.operation;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.operation.JSFProjectAdoptOperation;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.context.ImportWebWarContext;

public class ImportJSFWarOperation
extends JSFProjectAdoptOperation {
    public ImportJSFWarOperation(IImportWebProjectContext context) {
        super(context);
    }

    protected AbstractOperation createWTPNature(IProgressMonitor monitor) throws CoreException {
        this.copyProject();
        this.getProject().refreshLocal(2, monitor);
        return super.createWTPNature(monitor);
    }

    protected void createWebNature() throws CoreException {
        super.createWebNature();
    }

    @Override
    protected void execute() throws XModelException {
        ((ImportWebWarContext)this.context).prepareModules();
        super.execute();
    }

    protected void copyProject() {
        File d;
        String targetLocation = this.context.getSuggestedProjectLocation();
        ImportWebWarContext warContext = (ImportWebWarContext)this.context;
        String warLocation = warContext.getWarLocation();
        File target = new File(targetLocation);
        String[] os = warContext.getOriginalSources();
        String[] jss = warContext.getExistingSources();
        boolean classes = false;
        if (!warContext.isClassicEclipseProject()) {
            try {
                FileUtil.unjar((File)target, (String)warLocation);
            }
            catch (IOException e) {
                JsfUiPlugin.getPluginLog().logError((Throwable)e);
            }
            int i = 0;
            while (i < os.length) {
                File d2 = new File(os[i]);
                if (d2.isDirectory() && "classes".equals(d2.getName())) {
                    classes = true;
                }
                ++i;
            }
        } else {
            File webContent = new File(target, "WebContent");
            try {
                FileUtil.unjar((File)webContent, (String)warLocation);
            }
            catch (IOException e) {
                JsfUiPlugin.getPluginLog().logError((Throwable)e);
            }
            int i = 0;
            while (i < os.length) {
                File d3 = new File(os[i]);
                if (d3.isDirectory()) {
                    boolean delete;
                    File js = new File(jss[i]);
                    if ("classes".equals(d3.getName())) {
                        classes = true;
                    }
                    if (!d3.equals(js) && (delete = this.copySrc(d3, js))) {
                        FileUtil.clear((File)d3);
                        d3.delete();
                    }
                }
                ++i;
            }
        }
        if (!classes && jss.length > 0 && (d = new File(String.valueOf(this.context.getWebInfLocation()) + "/classes")).isDirectory()) {
            this.copySrc(d, new File(jss[0]));
        }
    }

    private boolean copySrc(File from, File to) {
        File[] fs = from.listFiles();
        if (fs == null) {
            return true;
        }
        boolean result = true;
        int i = 0;
        while (i < fs.length) {
            String n = fs[i].getName();
            File to1 = new File(to, n);
            if (fs[i].isDirectory() && !this.copySrc(fs[i], to1)) {
                result = false;
            }
            if (fs[i].isFile()) {
                if (!n.endsWith(".java") && !n.endsWith(".properties")) {
                    result = false;
                } else {
                    FileUtil.copyFile((File)fs[i], (File)to1, (boolean)true);
                }
            }
            ++i;
        }
        return result;
    }
}

