/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.text.ext.IMultiPageEditor;
import org.jboss.tools.jsf.jsf2.refactoring.RefactoringActionFactory;
import org.jboss.tools.jsf.jsf2.refactoring.RefactoringActionManager;
import org.jboss.tools.jsf.jsf2.refactoring.action.rename.IRenameDescriptor;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class RenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredTextEditor textEditor = null;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof IMultiPageEditor) {
            textEditor = ((IMultiPageEditor)editor).getSourceEditor();
        }
        if (textEditor == null) {
            RenameHandler.reportRefactoringInfo();
        } else {
            IEditorInput input = textEditor.getEditorInput();
            if (!(input instanceof IFileEditorInput)) {
                RenameHandler.reportRefactoringInfo();
                return null;
            }
            if (((IFileEditorInput)textEditor.getEditorInput()).getFile().getProject() == null) {
                RenameHandler.reportRefactoringInfo();
                return null;
            }
            IRenameDescriptor descriptor = RefactoringActionFactory.createRenameDescriptor((StructuredTextEditor)textEditor);
            RefactoringActionManager.getManager().renameWithAction(null, descriptor);
        }
        return null;
    }

    private static void reportRefactoringInfo() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)RefactoringMessages.RenameAction_rename, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Action);
    }
}

