/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.util.JSF2ResourceUtil;
import org.jboss.tools.jsf.project.JSF2Util;
import org.jboss.tools.jsf.ui.handlers.NameInputValidator;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.SourceEditorPageContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteTaglibInserter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class CreateJSF2CompositeCommandHandler
extends AbstractHandler {
    private static final Pattern USED_TAGLIBS_PATTERN = Pattern.compile("<([a-zA-Z]+\\d*)+:");
    private final String IMPLEMENTATION = "composite:implementation";
    private NameInputValidator nameInputValidator;
    private JSPMultiPageEditor editor;

    public void setEnabled(Object evaluationContext) {
        IEditorInput in;
        IEvaluationContext context;
        Object activeEditor;
        boolean enabled = false;
        if (evaluationContext instanceof IEvaluationContext && (activeEditor = (context = (IEvaluationContext)evaluationContext).getVariable("activeEditor")) instanceof ITextEditor && (in = ((ITextEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
            try {
                enabled = JSF2Util.isJSF2((IProject)((FileEditorInput)in).getFile().getProject());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.isEnabled() != enabled) {
            this.setBaseEnabled(enabled);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart ep = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (!(ep instanceof JSPMultiPageEditor)) return null;
        this.editor = (JSPMultiPageEditor)ep;
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (!(selection instanceof TextSelection) || !(selection instanceof IStructuredSelection)) return null;
        TextSelection textSelection = (TextSelection)selection;
        IStructuredSelection ss = (IStructuredSelection)selection;
        IProject project = this.editor.getProject();
        int offset = 0;
        int length = 0;
        if (ss.size() == 1 && ss.getFirstElement() instanceof TextImpl) {
            offset = textSelection.getOffset();
            length = textSelection.getLength();
        } else {
            Iterator it = ss.iterator();
            boolean first = true;
            while (it.hasNext()) {
                Object ob = it.next();
                if (!(ob instanceof NodeImpl)) continue;
                NodeImpl n = (NodeImpl)ob;
                if (first) {
                    offset = n.getStartOffset();
                    first = false;
                }
                length += n.getEndOffset() - n.getStartOffset();
            }
        }
        if (this.nameInputValidator == null) {
            this.nameInputValidator = new NameInputValidator(project);
        } else {
            this.nameInputValidator.setProject(project);
        }
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Creating composite component", "Enter component's namespace and name:", "namespace:name", (IInputValidator)this.nameInputValidator);
        if (dlg.open() != 0) return null;
        String componentName = dlg.getValue();
        String[] split = componentName.split(":", 2);
        String path = "";
        path = String.valueOf(componentName.replaceAll(":", "/")) + ".xhtml";
        if (project == null) return null;
        IStructuredModel model = null;
        try {
            try {
                IDOMModel domModel;
                IDOMDocument document;
                NodeList list;
                IFile createdFile = JSF2ResourceUtil.createCompositeComponentFile((IProject)project, (IPath)new Path(path));
                IModelManager manager = StructuredModelManager.getModelManager();
                if (manager == null || !((model = manager.getModelForEdit(createdFile)) instanceof IDOMModel) || (list = (document = (domModel = (IDOMModel)model).getDocument()).getElementsByTagName("composite:implementation")).getLength() != 1) return null;
                IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                String replacedText = doc.get(offset, length);
                String content = document.getStructuredDocument().getText();
                int index = content.indexOf("<composite:implementation>") + "<composite:implementation>".length();
                content = content.subSequence(0, index) + "\n" + replacedText + content.subSequence(index, content.length());
                domModel.reload((InputStream)new ByteArrayInputStream(content.getBytes()));
                model.save();
                String replacement = "<" + componentName + "> </" + componentName + ">";
                doc.replace(offset, length, replacement);
                StructuredTextEditor ed = this.editor.getSourceEditor();
                if (ed instanceof JSPTextEditor) {
                    String libraryUri = "http://java.sun.com/jsf/composite/" + split[0];
                    PaletteTaglibInserter PaletteTaglibInserter2 = new PaletteTaglibInserter();
                    Properties properties = new Properties();
                    properties.put("selectionProvider", this.editor.getSelectionProvider());
                    properties.setProperty("library uri", libraryUri);
                    properties.setProperty("library version", "");
                    properties.setProperty("default prefix", split[0]);
                    properties.setProperty("add taglib", "true");
                    properties.setProperty("automatically reformat tag body", "yes");
                    properties.setProperty("start text", "<%@ taglib uri=\"" + libraryUri + "\" prefix=\"" + split[0] + "\" %>\\n");
                    PaletteTaglibInserter2.inserTaglib(ed.getTextViewer().getDocument(), properties);
                }
                IVisualContext context = this.editor.getJspEditor().getPageContext();
                List tl = null;
                if (context instanceof SourceEditorPageContext) {
                    SourceEditorPageContext sourcePageContext = (SourceEditorPageContext)context;
                    tl = sourcePageContext.getTagLibs();
                    HashMap<String, String> sourceTaglibs = new HashMap<String, String>();
                    HashMap<String, String> requiredTaglibs = new HashMap<String, String>();
                    HashSet<String> compositeTaglibs = new HashSet<String>();
                    for (TaglibData taglibData : tl) {
                        sourceTaglibs.put(taglibData.getPrefix(), taglibData.getUri());
                    }
                    Matcher m = USED_TAGLIBS_PATTERN.matcher(replacedText);
                    while (m.find()) {
                        if (!sourceTaglibs.keySet().contains(m.group(1)) || requiredTaglibs.keySet().contains(m.group(1))) continue;
                        requiredTaglibs.put(m.group(1), (String)sourceTaglibs.get(m.group(1)));
                    }
                    list = document.getElementsByTagName("html");
                    if (list.getLength() == 1) {
                        Element html = (Element)list.item(0);
                        NamedNodeMap map = html.getAttributes();
                        int i = 0;
                        while (i < map.getLength()) {
                            compositeTaglibs.add(map.item(i).getNodeName());
                            ++i;
                        }
                        for (String key : requiredTaglibs.keySet()) {
                            String xmlns = "xmlns:" + key;
                            if (compositeTaglibs.contains(xmlns)) continue;
                            html.setAttribute(xmlns, (String)requiredTaglibs.get(key));
                        }
                    }
                }
                if (createdFile == null) {
                    JSFModelPlugin.getPluginLog().logError("Composite file:'" + path.toString() + "' cannot be created!");
                    return null;
                } else {
                    FileEditorInput input = new FileEditorInput(createdFile);
                    JSPMultiPageEditor part = (JSPMultiPageEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor", true);
                    part.setFocus();
                }
                return null;
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                if (model == null) return null;
                model.releaseFromEdit();
                return null;
            }
            catch (IOException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                if (model == null) return null;
                model.releaseFromEdit();
                return null;
            }
            catch (BadLocationException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                if (model == null) return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                model.releaseFromEdit();
                return null;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }
}

