/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.jobs;

import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jboss.tools.foundation.core.internal.Trace;

public class InterruptableJoinJob
extends Job {
    public InterruptableJoinJob(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        return null;
    }

    public void interruptableJoin() throws InterruptedException {
        this.interruptableJoin(false);
    }

    public void interruptableJoin(boolean schedule) throws InterruptedException {
        Trace.trace("/finer", "Joining job " + this.getName() + " in interruptable fashion");
        final Semaphore barrier2 = new Semaphore(null);
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Trace.trace("/finer", "Job " + event.getJob().getName() + " completed. Releasing barrier.");
                barrier2.release();
            }
        };
        this.addJobChangeListener((IJobChangeListener)listener);
        if (schedule) {
            Trace.trace("/finer", "Scheduling Job " + this.getName());
            this.schedule();
        }
        try {
            if (barrier2.acquire(Long.MAX_VALUE)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.trace("/finer", "Job " + this.getName() + " has been interrupted, so this join is terminating");
            throw new InterruptedException();
        }
    }
}

