/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.credentials.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.internal.CredentialsModel;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CredentialDomain
implements ICredentialDomain {
    static final String PROPERTY_ID = "id";
    static final String PROPERTY_NAME = "name";
    static final String PROPERTY_REMOVABLE = "removable";
    static final String PROPERTY_PASS = "pass";
    static final String PROPERTY_DEFAULT_USER = "default.user";
    static final String PROPERTY_USER_LIST = "user.list";
    static final String PROPERTY_PROMPTED_USER_LIST = "user.list.prompted";
    static final String NOT_LOADED_PASSWORD = "********";
    private String userVisibleName;
    private String id;
    private String defaultUsername;
    private boolean removable;
    private HashMap<String, String> credentials;
    private ArrayList<String> promptedCredentials;

    public CredentialDomain(String id, String name, boolean removable) {
        this.id = id;
        this.userVisibleName = name;
        this.removable = removable;
        this.defaultUsername = null;
        this.credentials = new HashMap();
        this.promptedCredentials = new ArrayList();
    }

    public CredentialDomain(Preferences pref) throws BackingStoreException {
        String[] users;
        this.id = pref.get(PROPERTY_ID, null);
        this.userVisibleName = pref.get(PROPERTY_NAME, null);
        this.removable = pref.getBoolean(PROPERTY_REMOVABLE, true);
        this.defaultUsername = pref.get(PROPERTY_DEFAULT_USER, null);
        this.credentials = new HashMap();
        String usersList = pref.get(PROPERTY_USER_LIST, null);
        if (usersList != null && !usersList.isEmpty()) {
            String[] users2 = usersList == null ? new String[]{} : usersList.split("\n");
            int i = 0;
            while (i < users2.length) {
                this.credentials.put(users2[i], NOT_LOADED_PASSWORD);
                ++i;
            }
        }
        String promptedUserList = pref.get(PROPERTY_PROMPTED_USER_LIST, null);
        this.promptedCredentials = new ArrayList();
        if (promptedUserList != null && !promptedUserList.isEmpty()) {
            String[] users3 = usersList == null ? new String[]{} : promptedUserList.split("\n");
            this.promptedCredentials.addAll(Arrays.asList(users3));
        }
        if (!(this.defaultUsername != null && this.userExists(this.defaultUsername) || (users = this.getUsernames()).length <= 0)) {
            this.defaultUsername = users[0];
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean getRemovable() {
        return this.removable;
    }

    @Override
    public String getName() {
        return this.userVisibleName;
    }

    @Override
    public boolean userExists(String user) {
        return this.credentials.containsKey(user) || this.promptedCredentials.contains(user);
    }

    public boolean userRequiresPrompt(String user) {
        return this.promptedCredentials.contains(user);
    }

    @Override
    public String[] getUsernames() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.addAll(this.credentials.keySet());
        ret.addAll(this.promptedCredentials);
        return ret.toArray(new String[ret.size()]);
    }

    protected void addCredentials(String user, String pass) {
        if (this.defaultUsername == null) {
            this.defaultUsername = user;
        }
        this.promptedCredentials.remove(user);
        this.credentials.put(user, pass);
    }

    protected void addPromptedCredentials(String user) {
        if (this.defaultUsername == null) {
            this.defaultUsername = user;
        }
        this.credentials.remove(user);
        this.promptedCredentials.add(user);
    }

    protected void removeCredential(String user) {
        this.credentials.remove(user);
        this.promptedCredentials.remove(user);
        if (user.equals(this.defaultUsername)) {
            String[] usernames = this.getUsernames();
            this.defaultUsername = usernames.length == 0 ? null : usernames[0];
        }
    }

    @Override
    public String getCredentials(String user) throws StorageException {
        if (!this.userRequiresPrompt(user)) {
            String ret = this.credentials.get(user);
            if (NOT_LOADED_PASSWORD.equals(ret)) {
                ISecurePreferences secureRoot = SecurePreferencesFactory.getDefault();
                ISecurePreferences secureCredentialRoot = secureRoot.node("org.jboss.tools.foundation.core.credentials.CredentialsModel");
                ISecurePreferences secureDomain = secureCredentialRoot.node(this.getId());
                ISecurePreferences secureUser = secureDomain.node(user);
                ret = secureUser.get(PROPERTY_PASS, null);
                this.credentials.put(user, ret);
            }
            return ret;
        }
        return CredentialsModel.getDefault().promptForPassword(this, user);
    }

    void saveToPreferences(Preferences prefs, ISecurePreferences securePrefs) throws StorageException {
        prefs.put(PROPERTY_ID, this.id);
        prefs.put(PROPERTY_NAME, this.userVisibleName);
        prefs.putBoolean(PROPERTY_REMOVABLE, this.removable);
        if (this.defaultUsername != null) {
            prefs.put(PROPERTY_DEFAULT_USER, this.defaultUsername);
        }
        Set<String> users = this.credentials.keySet();
        CharSequence[] userList = users.toArray(new String[users.size()]);
        prefs.put(PROPERTY_USER_LIST, String.join((CharSequence)"\n", userList));
        int i = 0;
        while (i < userList.length) {
            CharSequence user = userList[i];
            ISecurePreferences userNode = securePrefs.node((String)user);
            userNode.put(PROPERTY_PASS, this.getCredentials((String)user), true);
            ++i;
        }
        CharSequence[] promptedUsers = this.promptedCredentials.toArray(new String[this.promptedCredentials.size()]);
        prefs.put(PROPERTY_PROMPTED_USER_LIST, String.join((CharSequence)"\n", promptedUsers));
    }

    @Override
    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public void setDefaultUsername(String user) throws IllegalArgumentException {
        if (!this.userExists(user)) {
            throw new IllegalArgumentException("User " + user + " does not exist for this domain.");
        }
        this.defaultUsername = user;
    }
}

