/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.vpe.template;

import java.util.ArrayList;
import org.jboss.tools.seam.vpe.template.SeamPdfAbstractTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeamPdfDocumentTemplate
extends SeamPdfAbstractTemplate {
    private nsIDOMElement headElement;
    private Element sourceElement;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement headNode = visualDocument.createElement("div");
        this.headElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)headNode, nsIDOMElement.class);
        this.sourceElement = (Element)sourceNode;
        this.setMarginValues();
        return new VpeCreationData((nsIDOMNode)this.headElement);
    }

    private boolean setMarginValues(float ... marginValues) {
        if (marginValues.length != 4) {
            return false;
        }
        this.headElement.removeAttribute("style");
        this.headElement.setAttribute("style", "margin-left:" + Float.toString(marginValues[0]) + ";margin-right:" + Float.toString(marginValues[1]) + ";margin-top:" + Float.toString(marginValues[2]) + ";margin-bottom:" + Float.toString(marginValues[3]) + ";");
        return true;
    }

    private float[] parseMarginValues(String stringMarginValues) throws NumberFormatException {
        String[] parts = stringMarginValues.split("\\s");
        float[] values = new float[parts.length];
        int i = 0;
        while (i < parts.length) {
            values[i] = Float.valueOf(parts[i]).floatValue();
            ++i;
        }
        return values;
    }

    private void setDefaultMargingValues() {
        this.setMarginValues(36.0f, 36.0f, 36.0f, 36.0f);
    }

    private void setMarginValues() {
        String marginsAttrValue = this.sourceElement.getAttribute("margins");
        try {
            if (marginsAttrValue != null && !"".equals(marginsAttrValue)) {
                float[] floatMarginValues = this.parseMarginValues(marginsAttrValue);
                if (!this.setMarginValues(floatMarginValues)) {
                    this.setDefaultMargingValues();
                }
            } else {
                this.setDefaultMargingValues();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setDefaultMargingValues();
        }
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        this.setFooter(pageContext, sourceNode, data);
    }

    private void setFooter(VpePageContext pageContext, Node sourceNode, VpeCreationData data) {
        nsIDOMNode[] footers = this.findFootersForVisualDoc((nsIDOMElement)XPCOM.queryInterface((nsISupports)data.getNode(), nsIDOMElement.class));
        int footersLength = footers.length;
        if (footersLength == 0) {
            return;
        }
        nsIDOMNode visualFooter = footers[footersLength - 1];
        if (visualFooter != null) {
            int i = 0;
            while (i < footers.length) {
                nsIDOMNode visualFootersRepresent = footers[i];
                if (visualFootersRepresent != null && visualFootersRepresent != visualFooter) {
                    nsIDOMNode parentNode = visualFootersRepresent.getParentNode();
                    parentNode.removeChild(visualFootersRepresent);
                }
                ++i;
            }
            nsIDOMNode parentNode = visualFooter.getParentNode();
            if (parentNode != null) {
                parentNode.removeChild(visualFooter);
                data.getNode().appendChild(visualFooter);
            }
        }
    }

    private nsIDOMNode[] findFootersForVisualDoc(nsIDOMElement visualElement) {
        nsIDOMNodeList children = visualElement.getElementsByTagName("div");
        ArrayList<nsIDOMElement> childrenElements = new ArrayList<nsIDOMElement>();
        int i = 0;
        while ((long)i < children.getLength()) {
            nsIDOMElement childElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)children.item((long)i), nsIDOMElement.class);
            String attrType = childElement.getAttribute("TYPEID");
            if (attrType != null && "pdf-footer".equalsIgnoreCase(attrType)) {
                childrenElements.add(childElement);
            }
            ++i;
        }
        return (nsIDOMNode[])childrenElements.toArray(new nsIDOMElement[0]);
    }
}

