/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.ui.preferences.CDIPreferencesMessages;
import org.jboss.tools.common.ui.preferences.SettingsPage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;

public class CDISettingsPreferencePage
extends SettingsPage {
    public static final String ID = "org.jboss.tools.cdi.ui.propertyPages.CDISettingsPreferencePage";
    private IProject project;
    private boolean cdiEnabled;
    private boolean initialState;
    private boolean generateBeansXml;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout(1, false);
        root.setLayout((Layout)gridLayout);
        Composite generalGroup = new Composite(root, 0);
        generalGroup.setLayoutData((Object)gd);
        gridLayout = new GridLayout(4, false);
        generalGroup.setLayout((Layout)gridLayout);
        this.initialState = this.isCDIEnabled(this.project);
        IFieldEditor cdiSupportCheckBox = IFieldEditorFactory.INSTANCE.createCheckboxEditor(CDIPreferencesMessages.CDI_SETTINGS_PREFERENCE_PAGE_CDI_SUPPORT, CDIPreferencesMessages.CDI_SETTINGS_PREFERENCE_PAGE_CDI_SUPPORT, this.initialState);
        cdiSupportCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (value instanceof Boolean) {
                    boolean v = (Boolean)value;
                    CDISettingsPreferencePage.this.setEnabledCDISuport(v);
                }
            }
        });
        this.cdiEnabled = this.isCDIEnabled(this.project);
        this.registerEditor(cdiSupportCheckBox, generalGroup);
        this.generateBeansXml = false;
        this.validate();
        this.checkGenerateBeansXml();
        return root;
    }

    private void checkGenerateBeansXml() {
    }

    protected void performDefaults() {
        this.getEditor(CDIPreferencesMessages.CDI_SETTINGS_PREFERENCE_PAGE_CDI_SUPPORT).setValue((Object)this.isCDIEnabled(this.project));
        this.validate();
    }

    public boolean performOk() {
        if (this.isCDIEnabled() != this.initialState) {
            if (this.isCDIEnabled()) {
                this.addCDISupport(this.project);
            } else {
                this.removeCDISupport(this.project);
            }
        }
        return true;
    }

    private void addCDISupport(IProject project) {
        if (project == null) {
            return;
        }
        CDIUtil.enableCDI((IProject)project, (boolean)this.generateBeansXml, (IProgressMonitor)new NullProgressMonitor());
    }

    private void removeCDISupport(IProject project) {
        CDIUtil.disableCDI((IProject)project);
    }

    private boolean isCDIEnabled(IProject project) {
        return CDICorePlugin.getCDI((IProject)project, (boolean)false) != null;
    }

    private boolean isCDIEnabled() {
        return this.cdiEnabled;
    }

    public void setEnabledCDISuport(boolean enabled) {
        this.cdiEnabled = enabled;
        ((IFieldEditor)this.editorRegistry.get(CDIPreferencesMessages.CDI_SETTINGS_PREFERENCE_PAGE_CDI_SUPPORT)).setValue((Object)enabled);
        this.checkGenerateBeansXml();
    }

    protected void validate() {
    }
}

