/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.osgi.framework.Bundle;

public class IntegrateFeedhenrySDKOperation
extends WorkspaceModifyOperation {
    private final IProject project;

    public IntegrateFeedhenrySDKOperation(IProject project) {
        super((ISchedulingRule)project);
        this.project = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Integrate SDK to Project ", 100);
        if (this.canIntegrate()) {
            IFolder wwwFolder = this.project.getFolder("www");
            IFile feedhenryJSFile = wwwFolder.getFile("feedhenry.js");
            IFile fhconfigFile = wwwFolder.getFile("fhconfig.json");
            if (!fhconfigFile.exists()) {
                this.integrateFHConfigFile(fhconfigFile, monitor);
            }
            if (!feedhenryJSFile.exists()) {
                this.integrateFeedhenryJSFile(feedhenryJSFile, monitor);
            }
        }
        monitor.done();
    }

    private void integrateFHConfigFile(IFile file, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                InputStream stream = FileLocator.openStream((Bundle)FHPlugin.getDefault().getBundle(), (IPath)new Path("/res/templates/fhconfig.json"), (boolean)false);
                sm.worked(10);
                file.create(stream, true, (IProgressMonitor)sm.newChild(90));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", NLS.bind((String)"Unable to copy fhconfig.json template to project {0}", (Object)this.project.getName()), (Throwable)e));
            }
        }
        finally {
            sm.done();
        }
    }

    private void integrateFeedhenryJSFile(IFile file, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                InputStream stream = FileLocator.openStream((Bundle)FHPlugin.getDefault().getBundle(), (IPath)new Path("/res/templates/feedhenry.js"), (boolean)false);
                sm.worked(10);
                file.create(stream, true, (IProgressMonitor)sm.newChild(90));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", NLS.bind((String)"Unable to copy feedhenry.js to project {0}", (Object)this.project.getName()), (Throwable)e));
            }
        }
        finally {
            sm.done();
        }
    }

    private boolean canIntegrate() {
        IFolder wwwFolder = this.project.getFolder("www");
        return wwwFolder.isAccessible();
    }
}

