/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;

public class UrlResourceStore
extends ByteArrayResourceStore {
    private final URL url;

    public UrlResourceStore(URL url) throws ResourceStoreException {
        this.url = url;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = this.url.openStream();){
                this.setContents(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public void validateSave() {
        throw new ValidateEditException();
    }

    @Override
    protected LocalizationService initLocalizationService(Locale locale) {
        return new StandardLocalizationService(locale){

            @Override
            protected boolean load(Locale locale, Map<String, String> keyToText) {
                String origFileUrlString = UrlResourceStore.this.url.toString();
                int lastDot = origFileUrlString.lastIndexOf(46);
                if (lastDot != -1) {
                    String resFileUrlString = origFileUrlString.substring(0, lastDot);
                    String localeString = locale.toString();
                    if (localeString.length() > 0) {
                        resFileUrlString = String.valueOf(resFileUrlString) + "_" + localeString;
                    }
                    resFileUrlString = String.valueOf(resFileUrlString) + ".properties";
                    URL resFileUrl = null;
                    try {
                        resFileUrl = new URL(resFileUrlString);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return false;
                    }
                    try {
                        Throwable throwable = null;
                        Object var9_10 = null;
                        try (InputStream stream = resFileUrl.openStream();){
                            return 1.parse(stream, keyToText);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                return false;
            }
        };
    }
}

