/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class Context {
    public static final Context adapt(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        return new ClassLoaderContext(loader);
    }

    public static final Context adapt(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return new ClassContext(cl);
    }

    public abstract <T> Class<T> findClass(String var1);

    public abstract InputStream findResource(String var1);

    private static final class ClassContext
    extends ClassLoaderContext {
        private final String pkg;
        private final String path;

        public ClassContext(Class<?> cl) {
            super(cl.getClassLoader());
            Package pkg = cl.getPackage();
            if (pkg == null) {
                this.pkg = null;
                this.path = null;
            } else {
                this.pkg = pkg.getName();
                this.path = this.pkg.replace('.', '/');
            }
        }

        @Override
        public <T> Class<T> findClass(String name) {
            Class cl = super.findClass(name);
            if (cl == null && name.indexOf(46) == -1 && this.pkg != null) {
                cl = super.findClass(String.valueOf(this.pkg) + "." + name);
            }
            return cl;
        }

        @Override
        public InputStream findResource(String name) {
            InputStream stream = super.findResource(name);
            if (stream == null && name.indexOf(47) == -1 && this.path != null) {
                stream = super.findResource(String.valueOf(this.path) + "/" + name);
            }
            return stream;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ClassContext) {
                ClassContext context = (ClassContext)obj;
                return super.equals(context) && this.pkg.equals(context.pkg);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.pkg.hashCode();
        }
    }

    private static class ClassLoaderContext
    extends Context {
        private final ClassLoader loader;

        public ClassLoaderContext(ClassLoader loader) {
            if (loader == null) {
                throw new IllegalArgumentException();
            }
            this.loader = loader;
        }

        @Override
        public <T> Class<T> findClass(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            try {
                return this.loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        public InputStream findResource(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            URL url = this.loader.getResource(name);
            if (url != null) {
                try {
                    return url.openStream();
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassLoaderContext) {
                ClassLoaderContext context = (ClassLoaderContext)obj;
                return this.loader == context.loader;
            }
            return false;
        }

        public int hashCode() {
            return this.loader.hashCode();
        }
    }
}

