/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelItemLabelProvider<M extends ItemLabelProvider.Manager>
implements ItemLabelProvider {
    final Object item;
    final M manager;
    private final PropertyValueModel<ImageDescriptor> imageDescriptorModel;
    private final PropertyChangeListener imageDescriptorListener;
    private ImageDescriptor imageDescriptor;
    private boolean refreshImage = true;
    private Image image;
    private final PropertyValueModel<String> textModel;
    private final PropertyChangeListener textListener;
    private String text;
    private boolean disposed = false;

    protected AbstractModelItemLabelProvider(Object item, M manager, PropertyValueModel<ImageDescriptor> imageDescriptorModel, PropertyValueModel<String> textModel) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.item = item;
        if (manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
        if (imageDescriptorModel == null) {
            throw new NullPointerException();
        }
        this.imageDescriptorModel = imageDescriptorModel;
        if (textModel == null) {
            throw new NullPointerException();
        }
        this.textModel = textModel;
        this.imageDescriptorListener = this.buildImageDescriptorListener();
        this.imageDescriptorModel.addPropertyChangeListener("value", this.imageDescriptorListener);
        this.imageDescriptor = (ImageDescriptor)this.imageDescriptorModel.getValue();
        this.textListener = this.buildTextListener();
        this.textModel.addPropertyChangeListener("value", this.textListener);
        this.text = (String)this.textModel.getValue();
    }

    @Override
    public Image getImage() {
        if (this.refreshImage) {
            if (this.image != null) {
                this.manager.getResourceManager().destroyImage(this.imageDescriptor);
            }
            this.image = this.buildImage();
            this.refreshImage = false;
        }
        return this.image;
    }

    private Image buildImage() {
        return this.imageDescriptor == null ? null : this.manager.getResourceManager().createImage(this.imageDescriptor);
    }

    private PropertyChangeListener buildImageDescriptorListener() {
        return SWTListenerTools.wrap(this.buildImageDescriptorListener_(), (Viewer)this.manager.getViewer());
    }

    private PropertyChangeListener buildImageDescriptorListener_() {
        return new ImageDescriptorListener();
    }

    void imageDescriptorChanged(ImageDescriptor newValue) {
        if (this.isAlive()) {
            this.imageDescriptorChanged_(newValue);
        }
    }

    private void imageDescriptorChanged_(ImageDescriptor newValue) {
        this.refreshImage = true;
        this.imageDescriptor = newValue;
        this.manager.labelChanged(this.item);
    }

    @Override
    public String getText() {
        return this.text;
    }

    private PropertyChangeListener buildTextListener() {
        return SWTListenerTools.wrap(this.buildTextListener_(), (Viewer)this.manager.getViewer());
    }

    private PropertyChangeListener buildTextListener_() {
        return new TextListener();
    }

    void textChanged(String newValue) {
        if (this.isAlive()) {
            this.textChanged_(newValue);
        }
    }

    private void textChanged_(String newValue) {
        this.text = newValue;
        this.manager.labelChanged(this.item);
    }

    @Override
    public void dispose() {
        this.textModel.removePropertyChangeListener("value", this.textListener);
        this.text = null;
        if (this.image != null) {
            this.manager.getResourceManager().destroyImage(this.imageDescriptor);
            this.image = null;
        }
        this.refreshImage = true;
        this.imageDescriptorModel.removePropertyChangeListener("value", this.imageDescriptorListener);
        this.imageDescriptor = null;
        this.disposed = true;
    }

    @Override
    public boolean isLabelProperty(String property) {
        return true;
    }

    boolean isAlive() {
        return !this.disposed;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.item);
    }

    class ImageDescriptorListener
    extends PropertyChangeAdapter {
        ImageDescriptorListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractModelItemLabelProvider.this.imageDescriptorChanged((ImageDescriptor)event.getNewValue());
        }
    }

    class TextListener
    extends PropertyChangeAdapter {
        TextListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractModelItemLabelProvider.this.textChanged((String)event.getNewValue());
        }
    }
}

