/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.v7.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IServerProvider;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7Server;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerTCPIPMonitorUtil;

public class AS7ManagementDetails
implements IServerProvider,
IAS7ManagementDetails {
    private IServer server;
    private Map<String, Object> properties;

    public AS7ManagementDetails(IServer server) {
        this(server, new HashMap<String, Object>(0));
    }

    public AS7ManagementDetails(IServer server, Map<String, Object> props) {
        this.server = server;
        this.properties = props;
    }

    public String getHost() {
        return ServerTCPIPMonitorUtil.getHostFor((String)this.getUnderlyingHost(), (int)this.getUnderlyingPort());
    }

    public String getUnderlyingHost() {
        return this.server.getHost();
    }

    public int getManagementPort() {
        return ServerTCPIPMonitorUtil.getPortFor((String)this.getUnderlyingHost(), (int)this.getUnderlyingPort());
    }

    public int getUnderlyingPort() {
        JBoss7Server jbossServer = (JBoss7Server)this.server.loadAdapter(JBoss7Server.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossServer != null) {
            return jbossServer.getManagementPort();
        }
        return 9999;
    }

    public String getManagementUsername() {
        return null;
    }

    public String getManagementPassword() {
        return null;
    }

    public String[] handleCallbacks(String[] prompts) throws UnsupportedOperationException {
        boolean emptyCreds;
        ArrayList<String> requiredProperties = new ArrayList<String>();
        requiredProperties.addAll(Arrays.asList(prompts));
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)this.server);
        boolean bl = emptyCreds = !(jbs.getUsername() != null && !jbs.getUsername().equals("") || jbs.getPassword() != null && !jbs.getPassword().equals(""));
        if (!emptyCreds) {
            return new String[]{jbs.getUsername(), jbs.getPassword()};
        }
        Properties props = PollThreadUtils.requestCredentialsSynchronous(this, requiredProperties);
        if (props == null) {
            return null;
        }
        String[] rets = new String[prompts.length];
        int i = 0;
        while (i < rets.length) {
            rets[i] = (String)props.get(prompts[i]);
            ++i;
        }
        return rets;
    }

    public IServer getServer() {
        return this.server;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

