/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch.configuration;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.JavaUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.LaunchConfiguratorWithOverrides;

public abstract class AbstractStartLaunchConfigurator
extends LaunchConfiguratorWithOverrides {
    private static final String DEFAULT_CP_PROVIDER_ID = "org.jboss.ide.eclipse.as.core.server.internal.launch.serverClasspathProvider";
    private JBossLaunchConfigProperties properties = null;

    public AbstractStartLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    protected JBossLaunchConfigProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    protected JBossLaunchConfigProperties createProperties() {
        return new JBossLaunchConfigProperties();
    }

    protected JBossServer getJBossServer() {
        return (JBossServer)((Object)this.server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor()));
    }

    protected IJBossServerRuntime getJBossRuntime() throws CoreException {
        return RuntimeUtils.checkedGetJBossServerRuntime((IRuntime)this.runtime);
    }

    protected void doConfigure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        JBossServer jbossServer = this.getJBossServer();
        IJBossServerRuntime jbossRuntime = this.getJBossRuntime();
        this.getProperties().setProgramArguments(this.getDefaultProgramArguments(), launchConfig);
        this.getProperties().setHost(this.getHost(jbossServer, jbossRuntime), launchConfig);
        this.getProperties().setConfig(this.getServerConfig(jbossRuntime), launchConfig);
        this.getProperties().setServerHome(this.getServerHome(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setServerFlag(this.getSupportsServerFlag(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setVmArguments(this.getDefaultVMArguments(jbossRuntime), launchConfig);
        this.getProperties().setJreContainer(this.getJreContainerPath(jbossRuntime), launchConfig);
        this.getProperties().setEndorsedDir(this.getEndorsedDir(jbossRuntime), launchConfig);
        this.getProperties().setMainType(this.getMainType(), launchConfig);
        this.getProperties().setWorkingDirectory(this.getWorkingDirectory(), launchConfig);
        this.getProperties().setEnvironmentVariables(this.getEnvironmentVariables(), launchConfig);
        this.getProperties().setClasspathProvider(this.getClasspathProvider(), launchConfig);
        this.getProperties().setClasspath(this.getClasspath(this.getProperties().getClasspath((ILaunchConfiguration)launchConfig)), launchConfig);
        this.getProperties().setUseDefaultClassPath(this.isUseDefaultClasspath(), launchConfig);
        this.getProperties().setServerId(this.getServerId(this.server), launchConfig);
    }

    protected void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        JBossServer jbossServer = this.getJBossServer();
        IJBossServerRuntime jbossRuntime = this.getJBossRuntime();
        this.getProperties().setHost(this.getHost(jbossServer, jbossRuntime), launchConfig);
        this.getProperties().setConfig(this.getServerConfig(jbossRuntime), launchConfig);
        this.getProperties().setServerHome(this.getServerHome(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setServerFlag(this.getSupportsServerFlag(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setJreContainer(this.getJreContainerPath(jbossRuntime), launchConfig);
        this.getProperties().setEndorsedDir(this.getEndorsedDir(jbossRuntime), launchConfig);
        this.getProperties().setJavaLibPath(this.getJavaLibraryPath(jbossRuntime), launchConfig);
        this.getProperties().setWorkingDirectory(this.getWorkingDirectory(), launchConfig);
        this.getProperties().setClasspathProvider(this.getClasspathProvider(), launchConfig);
        this.getProperties().setClasspath(this.getClasspath(this.getProperties().getClasspath((ILaunchConfiguration)launchConfig)), launchConfig);
        this.getProperties().setUseDefaultClassPath(this.isUseDefaultClasspath(), launchConfig);
        this.getProperties().setServerId(this.getServerId(this.server), launchConfig);
    }

    protected boolean getSupportsServerFlag(IJBossServerRuntime runtime) {
        IVMInstall install = runtime.getVM();
        return JavaUtils.supportsServerMode((IVMInstall)install);
    }

    protected abstract String getEndorsedDir(IJBossServerRuntime var1);

    protected abstract String getJavaLibraryPath(IJBossServerRuntime var1);

    protected abstract String getServerConfig(IJBossServerRuntime var1);

    protected abstract String getServerHome(IJBossServerRuntime var1);

    protected boolean isCustomConfigLocation(IJBossServerRuntime runtime) {
        return runtime.getConfigLocation().equals("server");
    }

    protected abstract String getDefaultProgramArguments() throws CoreException;

    protected abstract String getMainType();

    protected abstract String getWorkingDirectory() throws CoreException;

    protected abstract List<String> getClasspath(List<String> var1) throws CoreException;

    protected boolean isUseDefaultClasspath() {
        return false;
    }

    protected String getClasspathProvider() {
        return DEFAULT_CP_PROVIDER_ID;
    }

    protected JBossExtendedProperties getExtendedProperties() {
        return (JBossExtendedProperties)this.getJBossServer().getServer().getAdapter(JBossExtendedProperties.class);
    }

    protected Map<String, String> getEnvironmentVariables() {
        return this.getExtendedProperties().getDefaultLaunchArguments().getDefaultRunEnvVars();
    }

    protected String getDefaultVMArguments(IJBossServerRuntime runtime) {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultVMArgs();
    }

    protected String getJreContainerPath(IJBossServerRuntime runtime) {
        IVMInstall vmInstall = runtime.getVM();
        if (vmInstall == null) {
            return null;
        }
        return JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString();
    }

    protected abstract String getHost(JBossServer var1, IJBossServerRuntime var2);
}

