/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IProjectTemplateList;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.template.ITemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class TemplateTreeItems
implements IModelFactory {
    public static final TemplateTreeItems INSTANCE = new TemplateTreeItems();

    @Override
    public <T> List<T> createChildren(Object parent) {
        if (parent instanceof Connection) {
            return ((Connection)parent).getResources("Project");
        }
        if (parent instanceof IProject) {
            IProject project = (IProject)parent;
            Collection templates = (Collection)project.accept((CapabilityVisitor)new CapabilityVisitor<IProjectTemplateList, Collection<ITemplate>>(){

                public Collection<ITemplate> visit(IProjectTemplateList capability) {
                    Collection templates = capability.getTemplates();
                    templates.addAll(capability.getCommonTemplates());
                    return templates;
                }
            }, Collections.emptyList());
            return new ArrayList(templates);
        }
        return Collections.emptyList();
    }

    public List<ObservableTreeItem> create(Collection<?> openShiftObjects) {
        if (openShiftObjects == null) {
            return Collections.emptyList();
        }
        ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
        for (Object openShiftObject : openShiftObjects) {
            ObservableTreeItem item = this.create(openShiftObject);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public ObservableTreeItem create(Object object) {
        return new ObservableTreeItem(object, this);
    }
}

