/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IResourceDetailsModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateTreeItems;

public class NewApplicationWizardModel
extends ResourceLabelsPageModel
implements IResourceDetailsModel,
ITemplateListPageModel,
ITemplateParametersPageModel {
    private Connection connection;
    private IProject project;
    private List<ObservableTreeItem> projectItems = new ArrayList<ObservableTreeItem>();
    private List<ObservableTreeItem> projectTemplates = new ArrayList<ObservableTreeItem>();
    private ITemplate selectedTemplate;
    private ITemplate localTemplate;
    private ITemplate serverTemplate;
    private List<IParameter> parameters = new ArrayList<IParameter>();
    private IParameter selectedParameter;
    private Map<String, String> originalValueMap;
    private Collection<IResource> items = new ArrayList<IResource>();
    private boolean useLocalTemplate = true;
    private String localTemplateFilename;
    private IResourceFactory resourceFactory;
    private org.eclipse.core.resources.IProject eclipseProject;

    private void update(boolean useUploadTemplate, IProject selectedProject, List<ObservableTreeItem> projectItems, ITemplate serverTemplate, String localTemplateFilename) {
        this.useLocalTemplate = useUploadTemplate;
        this.firePropertyChange("useLocalTemplate", this.useLocalTemplate, this.useLocalTemplate);
        this.updateProjectItems(projectItems);
        this.project = this.getProjectOrDefault(selectedProject, projectItems);
        this.firePropertyChange("project", this.project, this.project);
        this.projectTemplates = this.getProjectTemplates(this.project, projectItems);
        this.firePropertyChange("templates", this.projectTemplates, this.projectTemplates);
        this.updateSelectedTemplate(useUploadTemplate, serverTemplate, this.localTemplate, localTemplateFilename);
        this.updateTemplateParameters(this.selectedTemplate);
    }

    private void updateSelectedTemplate(boolean useLoadlTemplate, ITemplate serverTemplate, ITemplate localTemplate, String localTemplateFilename) {
        ITemplate template = null;
        if (useLoadlTemplate) {
            if (!ObjectUtils.equals((Object)localTemplateFilename, (Object)this.localTemplateFilename)) {
                template = this.localTemplate = this.getLocalTemplate(localTemplateFilename);
                this.localTemplateFilename = localTemplateFilename;
                this.firePropertyChange("localTemplateFileName", this.localTemplateFilename, this.localTemplateFilename);
            } else {
                template = localTemplate;
            }
        } else {
            template = this.serverTemplate = serverTemplate;
        }
        this.selectedTemplate = template;
        this.firePropertyChange("selectedTemplate", this.selectedTemplate, this.selectedTemplate);
    }

    private ITemplate getLocalTemplate(String filename) {
        ITemplate uploadedTemplate;
        block5: {
            if (StringUtils.isBlank((String)filename)) {
                return null;
            }
            uploadedTemplate = null;
            filename = VariablesHelper.replaceVariables((String)filename);
            if (Files.isRegularFile(Paths.get(filename, new String[0]), new LinkOption[0])) break block5;
            return null;
        }
        try {
            uploadedTemplate = (ITemplate)this.resourceFactory.create(this.createInputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not find the file \"{0}\" to upload", (Object)filename), new Object[0]);
        }
        catch (ResourceFactoryException | ClassCastException e) {
            throw e;
        }
        return uploadedTemplate;
    }

    private List<ObservableTreeItem> getProjectTemplates(IProject selectedProject, List<ObservableTreeItem> allProjects) {
        if (allProjects == null) {
            return null;
        }
        for (ObservableTreeItem item : allProjects) {
            if (!item.getModel().equals(selectedProject)) continue;
            return item.getChildren();
        }
        return allProjects;
    }

    private void updateProjectItems(List<ObservableTreeItem> projectItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.projectItems);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>();
        if (projectItems != null) {
            newItems.addAll(projectItems);
        }
        this.projectItems.clear();
        this.projectItems.addAll(newItems);
        this.firePropertyChange("projectItems", oldItems, this.projectItems);
    }

    @Override
    public Collection<IResource> getItems() {
        return this.items;
    }

    private void setItems(Collection<IResource> items) {
        this.items = items;
        this.firePropertyChange("items", this.items, this.items);
    }

    @Override
    public void setServerTemplate(ITemplate serverTemplate) {
        this.update(this.useLocalTemplate, this.project, this.projectItems, serverTemplate, this.localTemplateFilename);
    }

    @Override
    public ITemplate getServerTemplate() {
        return this.serverTemplate;
    }

    @Override
    public ITemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }

    private void updateTemplateParameters(ITemplate template) {
        if (template == null) {
            return;
        }
        this.setParameters(new ArrayList<IParameter>(template.getParameters().values()));
        this.setItems(template.getItems());
        this.setLabels(template.getObjectLabels());
    }

    private IProject getProjectOrDefault(IProject project, List<ObservableTreeItem> projects) {
        if (project == null) {
            project = this.getDefaultProject(projects);
        }
        return project;
    }

    @Override
    public void setProject(IProject project) {
        this.update(this.useLocalTemplate, project, this.projectItems, this.serverTemplate, this.localTemplateFilename);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void loadResources() {
        if (this.connection == null) {
            return;
        }
        ObservableTreeItem connectionItem = TemplateTreeItems.INSTANCE.create(this.connection);
        connectionItem.load();
        List<ObservableTreeItem> projects = connectionItem.getChildren();
        this.setProjectItems(projects);
    }

    @Override
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<IParameter> parameters) {
        this.parameters = NewApplicationWizardModel.injectProjectParameters(this.getEclipseProject(), parameters);
        this.firePropertyChange("parameters", this.parameters, this.parameters);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (parameters != null) {
            parameters.forEach(p -> {
                String string = paramsMap.put(p.getName(), p.getValue());
            });
        }
        this.originalValueMap = paramsMap;
    }

    private static List<IParameter> injectProjectParameters(org.eclipse.core.resources.IProject project, List<IParameter> originalParameters) {
        if (originalParameters == null || originalParameters.isEmpty()) {
            return originalParameters;
        }
        Map<String, String> projectParams = NewApplicationWizardModel.getProjectParameters(project);
        List<IParameter> newParameters = originalParameters.stream().map(p -> {
            IParameter clone = p.clone();
            String value = (String)projectParams.get(clone.getName());
            if (value != null) {
                clone.setValue(value);
            }
            return clone;
        }).collect(Collectors.toList());
        return newParameters;
    }

    private static Map<String, String> getProjectParameters(org.eclipse.core.resources.IProject project) {
        if (project == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> projectParams = new HashMap<String, String>();
        String gitRepo = null;
        try {
            gitRepo = StringUtils.defaultString((String)EGitUtils.getDefaultRemoteRepo((org.eclipse.core.resources.IProject)project));
        }
        catch (CoreException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not determine the default remote Git repository for \"{0}\"", (Object)project.getName()), new Object[0]);
        }
        if (gitRepo != null) {
            String branch;
            projectParams.put("SOURCE_REPOSITORY_URL", gitRepo);
            projectParams.put("GIT_URI", gitRepo);
            try {
                branch = StringUtils.defaultString((String)EGitUtils.getCurrentBranch((org.eclipse.core.resources.IProject)project));
            }
            catch (CoreException e) {
                throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not determine the default Git branch for \"{0}\"", (Object)project.getName()), new Object[0]);
            }
            projectParams.put("SOURCE_REPOSITORY_REF", branch);
            projectParams.put("GIT_REF", branch);
            String contextDir = "";
            projectParams.put("CONTEXT_DIR", contextDir);
            projectParams.put("GIT_CONTEXT_DIR", contextDir);
        }
        return projectParams;
    }

    @Override
    public IParameter getSelectedParameter() {
        return this.selectedParameter;
    }

    @Override
    public void setSelectedParameter(IParameter parameter) {
        this.selectedParameter = parameter;
        this.firePropertyChange("selectedParameter", this.selectedParameter, this.selectedParameter);
    }

    @Override
    public void updateParameterValue(IParameter param, String value) {
        param.setValue(value);
    }

    @Override
    public void resetParameter(IParameter param) {
        this.updateParameterValue(param, this.originalValueMap.get(param.getName()));
    }

    private void setLabels(Map<String, String> labelMap) {
        if (labelMap == null) {
            return;
        }
        ArrayList<IResourceLabelsPageModel.Label> labels = new ArrayList<IResourceLabelsPageModel.Label>(labelMap.size());
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            labels.add(new IResourceLabelsPageModel.Label(entry.getKey(), entry.getValue()));
        }
        this.setLabels(labels);
    }

    @Override
    public void setUseLocalTemplate(boolean uploadTemplate) {
        this.update(uploadTemplate, this.project, this.projectItems, this.serverTemplate, this.localTemplateFilename);
    }

    @Override
    public boolean isUseLocalTemplate() {
        return this.useLocalTemplate;
    }

    public InputStream createInputStream(String fileName) throws FileNotFoundException {
        return new FileInputStream(fileName);
    }

    @Override
    public void setLocalTemplateFileName(String filename) {
        this.update(this.useLocalTemplate, this.project, this.projectItems, this.serverTemplate, filename);
    }

    @Override
    public String getLocalTemplateFileName() {
        return this.localTemplateFilename;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        if (ObjectUtils.equals((Object)connection, (Object)this.connection)) {
            return;
        }
        this.setResourceFactory(connection);
        this.reset();
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
    }

    private void reset() {
        this.update(this.useLocalTemplate, null, null, null, null);
    }

    private IProject getDefaultProject(List<ObservableTreeItem> projects) {
        if (projects == null || projects.size() == 0) {
            return null;
        }
        return (IProject)projects.get(0).getModel();
    }

    private void setResourceFactory(Connection connection) {
        if (connection != null) {
            this.resourceFactory = connection.getResourceFactory();
        }
    }

    public void setResourceFactory(IResourceFactory factory) {
        this.resourceFactory = factory;
    }

    private void setProjectItems(List<ObservableTreeItem> projects) {
        this.update(this.useLocalTemplate, null, projects, this.serverTemplate, this.localTemplateFilename);
    }

    @Override
    public List<ObservableTreeItem> getProjectItems() {
        return this.projectItems;
    }

    @Override
    public List<ObservableTreeItem> getTemplates() {
        return this.projectTemplates;
    }

    @Override
    public boolean hasProjects() {
        return this.projectItems != null && !this.projectItems.isEmpty();
    }

    public Object getContext() {
        return null;
    }

    @Override
    public void setEclipseProject(org.eclipse.core.resources.IProject eclipseProject) {
        this.eclipseProject = eclipseProject;
        this.firePropertyChange("eclipseProject", this.eclipseProject, this.eclipseProject);
        this.updateTemplateParameters(this.selectedTemplate);
    }

    @Override
    public org.eclipse.core.resources.IProject getEclipseProject() {
        return this.eclipseProject;
    }
}

