/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAwareWizard;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.CreateApplicationFromTemplateJob;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizard;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.NewApplicationSummaryDialog;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.NewApplicationWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateListPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParametersPage;

public class NewApplicationWizard
extends Wizard
implements IWorkbenchWizard,
IConnectionAwareWizard<Connection> {
    private NewApplicationWizardModel model;

    public NewApplicationWizard() {
        this.setWindowTitle("New OpenShift Application");
        this.setNeedsProgressMonitor(true);
        this.model = new NewApplicationWizardModel();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IProject selectedProject = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
        this.model.setEclipseProject(selectedProject);
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection != null) {
            this.model.setConnection(connection);
        } else {
            IResource resource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
            if (resource != null) {
                this.model.setConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource));
                this.model.setProject(resource.getProject());
            }
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new TemplateListPage((IWizard)this, this.model));
        this.addPage((IWizardPage)new TemplateParametersPage((IWizard)this, this.model));
        this.addPage((IWizardPage)new ResourceLabelsPage((IWizard)this, this.model));
    }

    public boolean performFinish() {
        final CreateApplicationFromTemplateJob createJob = new CreateApplicationFromTemplateJob(this.model.getProject(), this.model.getSelectedTemplate(), this.model.getParameters(), this.model.getLabels());
        createJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = NLS.bind((String)"Results of creating the resources from the {0} template.", (Object)NewApplicationWizard.this.model.getSelectedTemplate().getName());
                            new NewApplicationSummaryDialog(NewApplicationWizard.this.getShell(), createJob, message).open();
                        }
                    });
                    OpenShiftUIUtils.showOpenShiftExplorerView();
                    if (NewApplicationWizard.this.model.getEclipseProject() != null) {
                        return;
                    }
                    final Map<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> projectsAndBuildConfigs = this.getBuildConfigs(createJob.getResources());
                    if (projectsAndBuildConfigs.isEmpty()) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ImportApplicationWizard wizard = new ImportApplicationWizard(projectsAndBuildConfigs);
                            new WizardDialog(NewApplicationWizard.this.getShell(), (IWizard)wizard).open();
                        }
                    });
                }
            }

            protected Map<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> getBuildConfigs(Collection<IResource> resources) {
                LinkedHashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> projects = new LinkedHashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>>();
                for (IResource resource : resources) {
                    IBuildConfig buildConfig;
                    if (!(resource instanceof IBuildConfig) || !StringUtils.isNotBlank((String)(buildConfig = (IBuildConfig)resource).getSourceURI())) continue;
                    com.openshift.restclient.model.IProject p = buildConfig.getProject();
                    LinkedHashSet<IBuildConfig> buildConfigs = (LinkedHashSet<IBuildConfig>)projects.get(p);
                    if (buildConfigs == null) {
                        buildConfigs = new LinkedHashSet<IBuildConfig>();
                        projects.put(p, buildConfigs);
                    }
                    buildConfigs.add(buildConfig);
                }
                return projects;
            }
        });
        boolean success = false;
        try {
            try {
                Job job = new JobChainBuilder((Job)createJob).runWhenSuccessfullyDone((Job)new RefreshResourcesJob(createJob, true)).build();
                IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)createJob.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
                success = this.isFailed(status);
            }
            catch (InterruptedException | InvocationTargetException e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                success = false;
                UsageStats.getInstance().newV3Application(this.model.getConnection().getHost(), success);
            }
        }
        finally {
            UsageStats.getInstance().newV3Application(this.model.getConnection().getHost(), success);
        }
        return success;
    }

    private boolean isFailed(IStatus status) {
        return JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status);
    }

    public Connection getConnection() {
        return this.model.getConnection();
    }

    public boolean hasConnection() {
        return this.model.hasConnection();
    }

    public void setConnection(Connection connection) {
        this.model.setConnection(connection);
    }

    public Object getContext() {
        return null;
    }
}

