/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryContentProvider;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryLabelProvider;
import org.jboss.tools.openshift.internal.ui.job.CreateApplicationFromTemplateJob;
import org.jboss.tools.openshift.internal.ui.webhooks.WebHooksDialog;
import org.jboss.tools.openshift.internal.ui.webhooks.WebhookUtil;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParameterViewerUtils;

public class NewApplicationSummaryDialog
extends ResourceSummaryDialog {
    private static final int COPIED_NOTIFICATION_SHOW_DURATION = 2000;
    private CreateApplicationFromTemplateJob job;

    public NewApplicationSummaryDialog(Shell parentShell, CreateApplicationFromTemplateJob job, String message) {
        super(parentShell, job.getResources(), "Create Application Summary", message, new ResourceSummaryLabelProvider(), new ResourceSummaryContentProvider());
        this.job = job;
    }

    @Override
    protected void createAreaAfterResourceSummary(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)area);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(area);
        final Collection<IBuildConfig> buildConfigs = this.findBuildConfigsWithWebHooks();
        if (!buildConfigs.isEmpty()) {
            Link webHooksLink = new Link(area, 0);
            webHooksLink.setText("Click <a>here</a> to display the webhooks available to automatically trigger builds.");
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)webHooksLink);
            webHooksLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WebHooksDialog dialog = new WebHooksDialog(NewApplicationSummaryDialog.this.getParentShell(), buildConfigs);
                    dialog.open();
                }
            });
        }
        if (this.job.getParameters().isEmpty()) {
            return;
        }
        Label lblParams = new Label(area, 64);
        lblParams.setText("Please make note of the following parameters which may include values required to administer your resources:");
        GridDataFactory.fillDefaults().align(4, 128).hint(100, -1).grab(true, false).applyTo((Control)lblParams);
        Composite container = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).equalWidth(false).applyTo(container);
        Composite parameters = new Composite(container, 0);
        GridDataFactory.fillDefaults().hint(100, 200).grab(true, true).applyTo((Control)parameters);
        TableViewer viewer = this.createTable(parameters);
        viewer.setInput(this.job.getParameters());
        Button copyToClipboard = new Button(container, 8);
        copyToClipboard.setImage(OpenShiftImages.COPY_TO_CLIPBOARD_IMG);
        copyToClipboard.setToolTipText("Copy parameters to clipboard");
        copyToClipboard.addSelectionListener((SelectionListener)this.onClickCopyButton((Control)lblParams));
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)copyToClipboard);
    }

    private SelectionAdapter onClickCopyButton(final Control control) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<IParameter> params = new ArrayList<IParameter>(NewApplicationSummaryDialog.this.job.getParameters());
                Collections.sort(params, new Comparator<IParameter>(){

                    @Override
                    public int compare(IParameter p1, IParameter p2) {
                        return p1.getName().compareTo(p2.getName());
                    }
                });
                String text = NewApplicationSummaryDialog.getAsString(params);
                NewApplicationSummaryDialog.this.copyToClipBoard(control, text, "Parameters copied to clipboard");
            }
        };
    }

    private static String getAsString(Collection<IParameter> parameters) {
        StringBuilder content = new StringBuilder();
        for (IParameter param : parameters) {
            content.append(NewApplicationSummaryDialog.getAsString(param)).append("\r\n");
        }
        return content.toString();
    }

    private static String getAsString(IParameter param) {
        StringBuilder content = new StringBuilder(param.getName());
        content.append(": ").append(param.getValue());
        return content.toString();
    }

    private void copyToClipBoard(Control control, String text, String notification) {
        this.copyToClipBoard(text);
        this.notifyCopied(control, notification);
    }

    private void notifyCopied(Control control, String notification) {
        DefaultToolTip copiedNotification = new DefaultToolTip(control, 2, true);
        copiedNotification.setText(notification);
        copiedNotification.setHideDelay(2000);
        copiedNotification.show(control.getLocation());
        copiedNotification.deactivate();
    }

    private void copyToClipBoard(String text) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Object[] data = new Object[]{text};
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(data, dataTypes);
        clipboard.dispose();
    }

    private Collection<IBuildConfig> findBuildConfigsWithWebHooks() {
        LinkedHashSet<IBuildConfig> buildConfigs = new LinkedHashSet<IBuildConfig>();
        for (IResource r : this.job.getResources()) {
            if (!(r instanceof IBuildConfig) || WebhookUtil.getWebHooks((IBuildConfig)r).isEmpty()) continue;
            buildConfigs.add((IBuildConfig)r);
        }
        return buildConfigs;
    }

    public TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 2816);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerBuilder.ICellToolTipProvider<IParameter> cellToolTipProvider = new TableViewerBuilder.ICellToolTipProvider<IParameter>(){

            public String getToolTipText(IParameter object) {
                return object.getDescription();
            }

            public int getToolTipDisplayDelayTime(IParameter object) {
                return 0;
            }
        };
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IParameter>(){

            public String getValue(IParameter variable) {
                return variable.getName();
            }
        }).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Name").align(16384).weight(2).minWidth(100).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IParameter>(){

            public String getValue(IParameter parameter) {
                return TemplateParameterViewerUtils.getValueLabel(parameter);
            }
        }).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        viewer.setComparator((ViewerComparator)new TemplateParameterViewerUtils.ParameterNameViewerComparator());
        viewer.addDoubleClickListener(this.onDoubleClick((Control)table));
        return viewer;
    }

    private IDoubleClickListener onDoubleClick(final Control control) {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String text;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IParameter param = (IParameter)selection.getFirstElement();
                if (param != null && StringUtils.isNotBlank((String)(text = param.getValue()))) {
                    String notification = String.valueOf(param.getName()) + " value copied to clipboard";
                    NewApplicationSummaryDialog.this.copyToClipBoard(control, text, notification);
                }
            }
        };
    }
}

