/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.ImportFailedException;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.WontOverwriteException;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.operation.ImportNewProject;

public class ImportJob
extends WorkspaceJob {
    private DelegatingProgressMonitor delegatingMonitor;
    private String gitUrl;
    private File cloneDestination;
    private String gitRef;
    private Collection<String> filters;

    public ImportJob(String gitUrl, File cloneDestination, DelegatingProgressMonitor delegatingMonitor) {
        super("Importing project to workspace...");
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.gitUrl = gitUrl;
        this.cloneDestination = cloneDestination;
        this.delegatingMonitor = delegatingMonitor;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.delegatingMonitor.add(monitor);
            new ImportNewProject(this.gitUrl, this.gitRef, this.cloneDestination, this.filters).execute((IProgressMonitor)this.delegatingMonitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (WontOverwriteException e) {
            this.openError("Project already present", e.getMessage());
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (ImportFailedException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not import project from {0}.", (Object)((Object)e), (Object)this.gitUrl));
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not import project from {0}.", (Object)e, (Object)this.gitUrl));
            return iStatus;
        }
        catch (OpenShiftException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not import project to the workspace.", (Throwable)e);
            return iStatus;
        }
        catch (URISyntaxException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("The url of the remote git repository is not valid", (Throwable)e);
            return iStatus;
        }
        catch (InvocationTargetException e) {
            TransportException te = this.getTransportException(e);
            if (te != null) {
                IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not clone the repository. Authentication failed.\n Please make sure that you added your private key to the ssh preferences.", (Throwable)te);
                return iStatus;
            }
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("An exception occurred while creating local git repository.", (Throwable)e);
            return iStatus;
        }
        catch (Exception e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not import project to the workspace.", (Throwable)e);
            return iStatus;
        }
        finally {
            this.delegatingMonitor.done();
        }
    }

    protected TransportException getTransportException(Throwable t) {
        if (t instanceof TransportException) {
            return (TransportException)t;
        }
        if (t instanceof InvocationTargetException) {
            return this.getTransportException(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof Exception) {
            return this.getTransportException(((Exception)t).getCause());
        }
        return null;
    }

    protected void openError(final String title, final String message) {
        final Shell shell = UIUtils.getShell();
        if (shell == null || shell.isDisposed()) {
            OpenShiftUIActivator.getDefault().getLogger().logError(message);
        } else {
            UIUtils.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                }
            });
        }
    }

    public ImportJob setGitRef(String gitRef) {
        this.gitRef = gitRef;
        return this;
    }

    public ImportJob setFilters(Collection<String> filters) {
        this.filters = filters;
        return this;
    }
}

