/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.build.IGitBuildSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IBuildConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IGitCloningPageModel;

public class ImportApplicationWizardModel
extends ObservableUIPojo
implements IBuildConfigPageModel,
IGitCloningPageModel {
    private Connection connection;
    private BuildConfigTreeItems.ConnectionTreeItem connectionItem;
    private Object selectedItem;
    private String repoPath;
    private boolean useDefaultRepoPath = true;
    private String projectName;
    private List<ObservableTreeItem> buildConfigs = new ArrayList<ObservableTreeItem>();

    ImportApplicationWizardModel() {
        this.repoPath = this.getDefaultRepoPath();
    }

    private String getDefaultRepoPath() {
        return EGitUIUtils.getEGitDefaultRepositoryPath();
    }

    @Override
    public IBuildConfig getSelectedBuildConfig() {
        return this.getBuildConfig(this.selectedItem);
    }

    private IBuildConfig getBuildConfig(Object item) {
        if (!(item instanceof IBuildConfig)) {
            return null;
        }
        return (IBuildConfig)item;
    }

    public String getGitUrl() {
        IBuildConfig config = this.getSelectedBuildConfig();
        if (config == null) {
            return null;
        }
        return config.getSourceURI();
    }

    public String getGitRef() {
        IBuildConfig config = this.getSelectedBuildConfig();
        if (config != null && config.getBuildSource() instanceof IGitBuildSource) {
            return ((IGitBuildSource)config.getBuildSource()).getRef();
        }
        return null;
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.selectedItem = selectedItem;
        this.firePropertyChange("selectedItem", this.selectedItem, this.selectedItem);
        this.setProjectName(this.getBuildConfig(selectedItem));
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setRepositoryPath(String path) {
        this.repoPath = path;
        this.firePropertyChange("repositoryPath", this.repoPath, this.repoPath);
    }

    @Override
    public String getRepositoryPath() {
        return this.repoPath;
    }

    public File getCloneDestination() {
        if (StringUtils.isEmpty((String)this.repoPath) || StringUtils.isEmpty((String)this.projectName)) {
            return null;
        }
        return new Path(this.repoPath).append(this.projectName).toFile();
    }

    @Override
    public void setUseDefaultRepositoryPath(boolean useDefault) {
        this.useDefaultRepoPath = useDefault;
        this.firePropertyChange("useDefaultRepositoryPath", this.useDefaultRepoPath, this.useDefaultRepoPath);
        if (this.useDefaultRepoPath) {
            this.setRepositoryPath(this.getDefaultRepoPath());
        }
    }

    @Override
    public boolean isUseDefaultRepositoryPath() {
        return this.useDefaultRepoPath;
    }

    private void setProjectName(IBuildConfig config) {
        this.setProjectName(ImportApplicationWizardModel.getProjectName(config));
    }

    private static String getProjectName(IBuildConfig config) {
        String projectName = config == null ? null : ImportApplicationWizardModel.extractProjectNameFromURI(config.getSourceURI());
        return projectName;
    }

    public static String extractProjectNameFromURI(String uri) {
        String projectName = null;
        if (uri != null) {
            uri = uri.trim();
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if (uri.endsWith(".git") && (uri = uri.substring(0, uri.length() - 4)).endsWith("/")) {
                return null;
            }
            int b = uri.lastIndexOf("/");
            if (b >= 0) {
                projectName = uri.substring(b + 1);
            }
        }
        return projectName;
    }

    @Override
    public void setProjectName(String name) {
        this.projectName = name;
        this.firePropertyChange("projectName", this.projectName, this.projectName);
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        this.connectionItem = new BuildConfigTreeItems.ConnectionTreeItem(connection);
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
    }

    @Override
    public List<ObservableTreeItem> getBuildConfigs() {
        return this.buildConfigs;
    }

    @Override
    public void loadBuildConfigs() {
        if (this.connectionItem == null) {
            return;
        }
        this.connectionItem.load();
        this.setBuildConfigs(this.connectionItem.getChildren());
    }

    private void setBuildConfigs(List<ObservableTreeItem> newBuildConfigs) {
        if (newBuildConfigs == null) {
            return;
        }
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.buildConfigs);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>(newBuildConfigs);
        this.buildConfigs.clear();
        this.buildConfigs.addAll(this.connectionItem.getChildren());
        this.firePropertyChange("buildConfigs", oldItems, newItems);
    }

    public Object getContext() {
        return null;
    }

    public String getGitContextDir() {
        IBuildConfig config = this.getSelectedBuildConfig();
        if (config != null && config.getBuildSource() instanceof IGitBuildSource) {
            return ((IGitBuildSource)config.getBuildSource()).getContextDir();
        }
        return null;
    }

    @Override
    public String getApplicationName() {
        String appName = null;
        IBuildConfig buildConfig = this.getSelectedBuildConfig();
        if (buildConfig != null) {
            appName = buildConfig.getName();
        }
        return appName;
    }
}

