/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IGitCloningPageModel;

public class GitCloningWizardPage
extends AbstractOpenShiftWizardPage {
    private IGitCloningPageModel model;
    private Button useDefaultRepoPathButton;
    private RepoPathValidationStatusProvider repoPathValidator;

    public GitCloningWizardPage(IWizard wizard, IGitCloningPageModel model) {
        super(GitCloningWizardPage.getTitle(model), "Configure the cloning settings by specifying the clone destination", "Cloning settings", wizard);
        this.model = model;
    }

    private static String getTitle(IGitCloningPageModel model) {
        String name = model == null ? null : model.getApplicationName();
        return name == null ? "Import an existing OpenShift application" : "Import the '" + name + "' OpenShift application";
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite cloneGroup = this.createCloneGroup(parent, dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneGroup);
        Composite filler = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filler);
    }

    private Composite createCloneGroup(Composite parent, DataBindingContext dbc) {
        Group cloneGroup = new Group(parent, 0);
        cloneGroup.setText("Cloning settings");
        cloneGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(10, 10).applyTo((Composite)cloneGroup);
        Composite composite = new Composite((Composite)cloneGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(15, 15).applyTo(composite);
        this.useDefaultRepoPathButton = new Button(composite, 32);
        this.useDefaultRepoPathButton.setText("Use default clone destination");
        this.useDefaultRepoPathButton.setToolTipText("Uncheck if you want to use a custom location to clone to");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)this.useDefaultRepoPathButton);
        Label labelForRepoPath = new Label(composite, 0);
        labelForRepoPath.setText("Git Clone Destination:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).indent(10, 0).applyTo((Control)labelForRepoPath);
        Text repoPathText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).align(4, 0x1000000).grab(true, false).applyTo((Control)repoPathText);
        ISWTObservableValue repoPathObservable = WidgetProperties.text((int)24).observe((Widget)repoPathText);
        IObservableValue repoPathModelObservable = BeanProperties.value((String)"repositoryPath").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)repoPathObservable).to(repoPathModelObservable).in(dbc);
        Button browseRepoPathButton = new Button(composite, 8);
        browseRepoPathButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)browseRepoPathButton);
        browseRepoPathButton.addSelectionListener(this.onRepoPath());
        ISWTObservableValue isDefaultRepoObservable = WidgetProperties.selection().observe((Widget)this.useDefaultRepoPathButton);
        IObservableValue useDefaultRepoModelObservable = BeanProperties.value((String)"useDefaultRepositoryPath").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)isDefaultRepoObservable).to(useDefaultRepoModelObservable).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)repoPathText)).notUpdating(useDefaultRepoModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)browseRepoPathButton)).notUpdating(useDefaultRepoModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        UIUtils.focusOnSelection((Button)this.useDefaultRepoPathButton, (Text)repoPathText);
        this.repoPathValidator = new RepoPathValidationStatusProvider((IObservableValue)repoPathObservable, BeanProperties.value((String)"projectName").observe((Object)this.model));
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.repoPathValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)this.repoPathValidator, (int)16512);
        return cloneGroup;
    }

    private SelectionListener onRepoPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(GitCloningWizardPage.this.getShell());
                dialog.setText("Git clone location");
                dialog.setMessage("Choose the location for git clone...");
                dialog.setFilterPath(GitCloningWizardPage.this.model.getRepositoryPath());
                String repositoryPath = dialog.open();
                if (repositoryPath != null) {
                    GitCloningWizardPage.this.model.setRepositoryPath(repositoryPath);
                }
            }
        };
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.repoPathValidator.forceRevalidate();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setTitle(GitCloningWizardPage.getTitle(this.model));
        }
        super.setVisible(visible);
    }

    class RepoPathValidationStatusProvider
    extends MultiValidator {
        private final IObservableValue repoPathObservable;
        private final IObservableValue projectNameObservable;

        public RepoPathValidationStatusProvider(IObservableValue repoPathObservable, IObservableValue projectNameObservable) {
            this.repoPathObservable = repoPathObservable;
            this.projectNameObservable = projectNameObservable;
        }

        protected IStatus validate() {
            IPath projectPath;
            String repoPath = (String)this.repoPathObservable.getValue();
            String projectName = (String)this.projectNameObservable.getValue();
            Path repoResourcePath = new Path(repoPath);
            if (repoResourcePath.isEmpty() || !repoResourcePath.isAbsolute()) {
                return ValidationStatus.cancel((String)"You need to provide an absolute path that we'll clone to.");
            }
            if (!FileUtils.canWrite((String)repoResourcePath.toOSString())) {
                return ValidationStatus.error((String)NLS.bind((String)"The location {0} is not writeable.", (Object)repoResourcePath.toOSString()));
            }
            IPath iPath = projectPath = projectName != null ? repoResourcePath.append((IPath)new Path(projectName)) : null;
            if (projectPath != null && projectPath.toFile().exists()) {
                return ValidationStatus.error((String)NLS.bind((String)"The location \"{0}\" already contains a folder named \"{1}\"\nPlease move it or use a different destination.", (Object)repoResourcePath.toOSString(), (Object)projectName));
            }
            return ValidationStatus.ok();
        }

        public void forceRevalidate() {
            this.revalidate();
        }
    }
}

