/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemStyledCellLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IBuildConfigPageModel;

public class BuildConfigWizardPage
extends AbstractOpenShiftWizardPage {
    public IBuildConfigPageModel model;

    public BuildConfigWizardPage(IWizard wizard, IBuildConfigPageModel model) {
        super("Select Build Config", "Choose the build config that will be used to import a project to Eclipse", "", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Group buildConfigsGroup = new Group(parent, 0);
        buildConfigsGroup.setText("Existing Build Configs:");
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)buildConfigsGroup);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)buildConfigsGroup);
        TreeViewer buildConfigsViewer = this.createBuildConfigsViewer(new Tree((Composite)buildConfigsGroup, 2820), this.model, dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).span(1, 2).applyTo(buildConfigsViewer.getControl());
        final IObservableValue selectedItem = BeanProperties.value((String)"selectedItem").observe((Object)this.model);
        Binding selectedBuildConfigBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)buildConfigsViewer)).converting((IConverter)new ObservableTreeItem2ModelConverter())).to(selectedItem).converting((IConverter)new BuildConfigTreeItems.Model2ObservableTreeItemConverter())).in(dbc);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                if (!(selectedItem.getValue() instanceof IBuildConfig)) {
                    return ValidationStatus.cancel((String)"Please select the existing build config that you want to import");
                }
                return ValidationStatus.ok();
            }
        });
        BeanProperties.value((String)"connection").observe((Object)this.model).addValueChangeListener(this.onConnectionChanged(buildConfigsViewer, this.model));
        ControlDecorationSupport.create((ValidationStatusProvider)selectedBuildConfigBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button refreshButton = new Button((Composite)buildConfigsGroup, 8);
        refreshButton.setText("&Refresh");
        GridDataFactory.fillDefaults().align(4, 4).hint(100, -1).applyTo((Control)refreshButton);
        refreshButton.addSelectionListener(this.onRefresh(buildConfigsViewer, this.model));
        Label fillerLabel = new Label((Composite)buildConfigsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo((Control)fillerLabel);
        this.loadBuildConfigs(this.model);
    }

    private TreeViewer createBuildConfigsViewer(Tree tree, IBuildConfigPageModel model, DataBindingContext dbc) {
        TreeViewer buildConfigsViewer = new TreeViewer(tree);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"buildConfigs"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        buildConfigsViewer.setContentProvider((IContentProvider)contentProvider);
        buildConfigsViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemStyledCellLabelProvider());
        buildConfigsViewer.setAutoExpandLevel(-1);
        buildConfigsViewer.setComparator(new ViewerComparator());
        buildConfigsViewer.setInput((Object)model);
        return buildConfigsViewer;
    }

    private SelectionListener onRefresh(final TreeViewer viewer, final IBuildConfigPageModel model) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildConfigWizardPage.this.loadBuildConfigs(model);
                viewer.expandAll();
            }
        };
    }

    private IValueChangeListener onConnectionChanged(final TreeViewer viewer, final IBuildConfigPageModel model) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                BuildConfigWizardPage.this.loadBuildConfigs(model);
                viewer.expandAll();
            }
        };
    }

    private void loadBuildConfigs(final IBuildConfigPageModel model) {
        try {
            AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading build configs..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    model.loadBuildConfigs();
                    return Status.OK_STATUS;
                }
            };
            WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }
}

