/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;

public class ServicePortDialog
extends AbstractOpenShiftWizardPage {
    static final String PROPERTY_SERVICE_PORT = "port";
    static final String PROPERTY_POD_PORT = "targetPort";
    private IServicePort model;
    private List<IServicePort> ports;
    private final int servicePort;
    private final String podPort;

    public ServicePortDialog(IServicePort model, String message, List<IServicePort> ports) {
        super("Configure Service Ports", message, "", null);
        this.model = model;
        this.ports = ports;
        this.servicePort = model.getPort();
        this.podPort = model.getTargetPort();
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(parent);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(25, 25).applyTo(dialogArea);
        Label lblServicePort = new Label(dialogArea, 0);
        lblServicePort.setText("Service port:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)lblServicePort);
        Spinner servicePortSpinner = new Spinner(dialogArea, 2048);
        servicePortSpinner.setMinimum(1);
        servicePortSpinner.setMaximum(65535);
        servicePortSpinner.setToolTipText("The port exposed by the service that will route to the pod.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)servicePortSpinner);
        Binding servicePortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)servicePortSpinner)).validatingAfterConvert((IValidator)new ServicePortValidator())).to(BeanProperties.value((String)PROPERTY_SERVICE_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)servicePortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label lblPodPort = new Label(dialogArea, 0);
        lblPodPort.setText("Pod port:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)lblPodPort);
        Text txtTargetPort = new Text(dialogArea, 2048);
        txtTargetPort.setToolTipText("The port exposed by the pod which will accept traffic.\nIt must be an integer or named port on the pod.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtTargetPort);
        Binding podPortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)txtTargetPort)).validatingAfterConvert((IValidator)new PodPortValidator())).to(BeanProperties.value((String)PROPERTY_POD_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)podPortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label lbl = new Label(dialogArea, 0);
        lbl.setText("Pod port is linked to service port changes");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)lbl);
    }

    public int open() {
        ServicePortDialog page = this;
        Wizard wizard = new Wizard((IWizardPage)page){
            private final /* synthetic */ IWizardPage val$page;
            {
                this.val$page = iWizardPage;
            }

            public boolean performFinish() {
                return true;
            }

            public void addPages() {
                this.addPage(this.val$page);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle("Service Ports");
        this.setWizard((IWizard)wizard);
        OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(this.getShell(), (IWizard)wizard);
        return dialog.open();
    }

    class PodPortValidator
    implements IValidator {
        private final int MAXLENGTH = 63;
        private final Pattern REGEXP = Pattern.compile("[a-z0-9]([a-z0-9-]*[a-z0-9])*");
        private final IStatus ERROR = ValidationStatus.error((String)"The target port must be at most 15 characters, matching regex [a-z0-9]([a-z0-9-]*[a-z0-9])*, and hyphens cannot be adjacent to other hyphens): e.g. \"http\"");

        PodPortValidator() {
        }

        public IStatus validate(Object value) {
            if (StringUtils.isEmpty((Object)value)) {
                return this.ERROR;
            }
            String newPort = (String)value;
            if (!ServicePortDialog.this.podPort.equals(newPort)) {
                if (newPort.length() > 63 || !this.REGEXP.matcher(newPort).matches()) {
                    return this.ERROR;
                }
                for (IServicePort port : ServicePortDialog.this.ports) {
                    if (!port.getTargetPort().equals(newPort)) continue;
                    return this.ERROR;
                }
            }
            return ValidationStatus.OK_STATUS;
        }
    }

    class ServicePortValidator
    implements IValidator {
        ServicePortValidator() {
        }

        public IStatus validate(Object value) {
            Integer newPort = (Integer)value;
            if (ServicePortDialog.this.servicePort != newPort) {
                for (IServicePort port : ServicePortDialog.this.ports) {
                    if (newPort.intValue() != port.getPort()) continue;
                    return ValidationStatus.error((String)"The service port number must be unique among all the other ports exposed by this OpenShift service.");
                }
            }
            return ValidationStatus.OK_STATUS;
        }
    }
}

