/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IServicePort;
import org.jboss.tools.common.databinding.ObservablePojo;

class ServicePortAdapter
extends ObservablePojo
implements IServicePort {
    private static final String TARGET_PORT = "targetPort";
    private String name;
    private int port;
    private String containerPort;
    private String protocol;

    ServicePortAdapter(IPort port) {
        this.name = port.getName();
        this.port = port.getContainerPort();
        this.containerPort = String.valueOf(port.getContainerPort());
        this.protocol = port.getProtocol();
    }

    ServicePortAdapter(IServicePort port) {
        this.name = port.getName();
        this.port = port.getPort();
        this.containerPort = "0".equals(port.getTargetPort()) ? String.valueOf(this.port) : port.getTargetPort();
        this.protocol = port.getProtocol();
    }

    public ServicePortAdapter() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.firePropertyChange("port", this.port, this.port);
    }

    public String getTargetPort() {
        return this.containerPort;
    }

    public void setTargetPort(int port) {
        this.containerPort = String.valueOf(port);
        this.firePropertyChange(TARGET_PORT, this.containerPort, this.containerPort);
    }

    public void setTargetPort(String intOrString) {
        this.containerPort = String.valueOf(intOrString);
        this.firePropertyChange(TARGET_PORT, this.containerPort, this.containerPort);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
        this.firePropertyChange("protocol", this.protocol, this.protocol);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + (this.containerPort == null ? 0 : this.containerPort.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServicePortAdapter other = (ServicePortAdapter)((Object)obj);
        if (this.port != other.port) {
            return false;
        }
        if (this.containerPort == null ? other.containerPort != null : !this.containerPort.equals(other.containerPort)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

