/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IPort;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.NLS;

public class PortSpecAdapter
implements IPort {
    private String name;
    private String protocol;
    private int port;

    public PortSpecAdapter(String spec) {
        String[] parts = StringUtils.defaultIfBlank((String)spec, (String)"").split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException(NLS.bind((String)"Unable to determine port info from spec {0}", (Object)spec));
        }
        this.port = Integer.valueOf(parts[0]);
        this.protocol = parts[1].toUpperCase();
        this.name = NLS.bind((String)"{0}-{1}", (Object)this.port, (Object)this.protocol.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public int getContainerPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

