/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueWizardModel;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizard;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizardModelBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.validator.EnvironmentVarKeyValidator;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeploymentConfigPageModel;

public class DeploymentConfigPage
extends AbstractOpenShiftWizardPage {
    private static final String PAGE_NAME = "Deployment Config Settings Page";
    private static final String PAGE_TITLE = "Deployment Configuration && Scalability";
    private static final String PAGE_DESCRIPTION = "";
    private static final String ENVIRONMENT_VARIABLE_LABEL = "Environment Variable";
    private IDeploymentConfigPageModel model;
    private TableViewer envViewer;
    private TableViewer dataViewer;

    protected DeploymentConfigPage(IWizard wizard, IDeploymentConfigPageModel model) {
        super(PAGE_TITLE, PAGE_DESCRIPTION, PAGE_NAME, wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        this.createEnvVariableControl(parent, dbc);
        this.createDataVolumeControl(parent, dbc);
        Composite scalingContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scalingContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(scalingContainer);
        Label lblReplicas = new Label(scalingContainer, 0);
        lblReplicas.setText("Replicas:");
        lblReplicas.setToolTipText("Replicas are the number of copies of an image that will be scheduled to run on OpenShift");
        GridDataFactory.fillDefaults().applyTo((Control)lblReplicas);
        Spinner replicas = new Spinner(scalingContainer, 2048);
        replicas.setMinimum(1);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)replicas);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)replicas)).to(BeanProperties.value((String)"replicas").observe((Object)this.model)).in(dbc);
    }

    private void createEnvVariableControl(Composite parent, DataBindingContext dbc) {
        Composite envContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)envContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(envContainer);
        Label lblEnvVars = new Label(envContainer, 0);
        lblEnvVars.setText("Environment variables:");
        lblEnvVars.setToolTipText("Environment variables are passed to running pods for consumption by the pod containers");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)lblEnvVars);
        Composite tableContainer = new Composite(envContainer, 0);
        this.envViewer = this.createEnvVarTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.envViewer)).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).in(dbc);
        this.envViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.envViewer.setInput((Object)BeanProperties.list((String)"environmentVariables").observe((Object)this.model));
        Button addButton = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)addButton);
        addButton.setText("Add...");
        addButton.setToolTipText("Add an environment variable declared by the docker image.");
        addButton.addSelectionListener(this.onAdd());
        Button editExistingButton = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit...");
        editExistingButton.setToolTipText("Edit the environment variable declared by the docker image.");
        editExistingButton.addSelectionListener((SelectionListener)new EditHandler());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button btnReset = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnReset);
        btnReset.setText("Reset");
        btnReset.setToolTipText("Reset to the value declared by the docker image.");
        btnReset.addSelectionListener(this.onResetEnvVar());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnReset)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                Boolean notNull = (Boolean)super.convert(fromObject);
                if (notNull.booleanValue() && !((EnvironmentVariable)fromObject).isNew()) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        Button btnRemove = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnRemove);
        btnRemove.setText("Remove");
        btnRemove.setToolTipText("Remove the environment variable added here.");
        btnRemove.addSelectionListener(this.onRemoveEnvVar());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnRemove)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                Boolean notNull = (Boolean)super.convert(fromObject);
                if (notNull.booleanValue() && ((EnvironmentVariable)fromObject).isNew()) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
    }

    private void createDataVolumeControl(Composite parent, DataBindingContext dbc) {
        Composite sectionContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)sectionContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(sectionContainer);
        Label lblSection = new Label(sectionContainer, 0);
        lblSection.setText("Data volumes:");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)lblSection);
        Composite tableContainer = new Composite(sectionContainer, 0);
        this.dataViewer = this.createDataVolumeTable(tableContainer);
        this.dataViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.dataViewer)).to(BeanProperties.value((String)"selectedVolume").observe((Object)this.model));
        this.dataViewer.setInput((Object)BeanProperties.list((String)"volumes").observe((Object)this.model));
        Label lblNotice = new Label(sectionContainer, 64);
        lblNotice.setText(NLS.bind((String)"NOTICE: This image might use an EmptyDir volume. Data in EmptyDir volumes is not persisted across deployments.", (Object)this.model.getName()));
        GridDataFactory.fillDefaults().align(4, 4).span(2, 2).applyTo((Control)lblNotice);
    }

    private SelectionListener onResetEnvVar() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariable envVar = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)DeploymentConfigPage.this.envViewer.getSelection(), EnvironmentVariable.class);
                if (MessageDialog.openQuestion((Shell)DeploymentConfigPage.this.getShell(), (String)"Reset Environment Variable", (String)NLS.bind((String)"Are you sure you want to reset the {0} {1}?", (Object)DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase(), (Object)envVar.getKey()))) {
                    DeploymentConfigPage.this.model.resetEnvironmentVariable(envVar);
                    DeploymentConfigPage.this.envViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onRemoveEnvVar() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariable envVar = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)DeploymentConfigPage.this.envViewer.getSelection(), EnvironmentVariable.class);
                if (MessageDialog.openQuestion((Shell)DeploymentConfigPage.this.getShell(), (String)"Remove Environment Variable", (String)NLS.bind((String)"Are you sure you want to remove the {0} {1}?", (Object)DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase(), (Object)envVar.getKey()))) {
                    DeploymentConfigPage.this.model.removeEnvironmentVariable(envVar);
                    DeploymentConfigPage.this.envViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder().windowTitle(DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL).title("Add Environment Variable").description(NLS.bind((String)"Add an {0}.", (Object)DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase())).keyLabel("Name").groupLabel(DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL).keyAfterConvertValidator((IValidator)new EnvironmentVarKeyValidator()).build();
                OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(DeploymentConfigPage.this.getShell(), (IWizard)new KeyValueWizard(dialogModel));
                if (dialog.open() == 0) {
                    DeploymentConfigPage.this.model.addEnvironmentVariable(dialogModel.getKey(), dialogModel.getValue());
                }
            }
        };
    }

    protected TableViewer createEnvVarTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.envViewer = new TableViewerBuilder(table, tableContainer).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IKeyValueItem>(){

            public String getValue(IKeyValueItem label) {
                return label.getKey();
            }
        }).name("Name").align(16384).weight(2).minWidth(75).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IKeyValueItem>(){

            public String getValue(IKeyValueItem label) {
                return label.getValue();
            }
        }).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        this.envViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IKeyValueItem first = (IKeyValueItem)e1;
                IKeyValueItem other = (IKeyValueItem)e2;
                return first.getKey().compareTo(other.getKey());
            }
        });
        this.envViewer.addDoubleClickListener((IDoubleClickListener)new EditHandler());
        return this.envViewer;
    }

    protected TableViewer createDataVolumeTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.dataViewer = new TableViewerBuilder(table, tableContainer).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<String>(){

            public String getValue(String label) {
                return label;
            }
        }).name("Container Path").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        this.dataViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String first = (String)e1;
                String other = (String)e2;
                return first.compareTo(other);
            }
        });
        return this.dataViewer;
    }

    private class EditHandler
    extends SelectionAdapter
    implements IDoubleClickListener {
        private EditHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.handleEvent();
        }

        private void handleEvent() {
            EnvironmentVariable var = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)DeploymentConfigPage.this.envViewer.getSelection(), EnvironmentVariable.class);
            IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder((IKeyValueItem)var).windowTitle(DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL).title("Edit Environment Variable").description(NLS.bind((String)"Edit the {0}.", (Object)DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase())).keyLabel(DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL).editableKey(var.isNew()).groupLabel(DeploymentConfigPage.ENVIRONMENT_VARIABLE_LABEL).keyAfterConvertValidator((IValidator)new EnvironmentVarKeyValidator()).build();
            OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(DeploymentConfigPage.this.getShell(), (IWizard)new KeyValueWizard((IKeyValueItem)var, dialogModel));
            if (dialog.open() == 0) {
                DeploymentConfigPage.this.model.updateEnvironmentVariable(var, dialogModel.getKey(), dialogModel.getValue());
            }
        }
    }
}

