/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IProject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.explorer.OpenShiftExplorerLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemLabelProvider;
import org.jboss.tools.openshift.internal.ui.validator.DeployImageNameValidator;
import org.jboss.tools.openshift.internal.ui.validator.DockerImageValidator;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImagePageModel;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizard;

public class DeployImagePage
extends AbstractOpenShiftWizardPage {
    private static final String PAGE_DESCRIPTION = "This page allows you to choose an image and the name to be used for the deployed resources.";
    private IDeployImagePageModel model;

    protected DeployImagePage(IWizard wizard, IDeployImagePageModel model) {
        super("Deploy an Image", PAGE_DESCRIPTION, "Deployment Config Settings Page", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(parent);
        if (this.model.originatedFromDockerExplorer()) {
            this.createConnectionControl(parent, dbc);
        } else {
            this.createDockerConnectionControl(parent, dbc);
        }
        this.createProjectControl(parent, dbc);
        Label lblImage = new Label(parent, 0);
        lblImage.setText("Image: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblImage);
        Text txtImage = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtImage);
        ISWTObservableValue imageTextObservable = WidgetProperties.text((int)24).observeDelayed(500, (Widget)txtImage);
        Binding imageBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)imageTextObservable).validatingAfterConvert((IValidator)new DockerImageValidator(){

            @Override
            public IStatus additionalValidation(String imageName) {
                if (!DeployImagePage.this.model.imageExists(imageName)) {
                    return ValidationStatus.cancel((String)"This docker image was not pulled in the selected Docker connection. Mapping ports will not be possible.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"image").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)imageBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button btnDockerSearch = new Button(parent, 0);
        btnDockerSearch.setText("Search...");
        btnDockerSearch.setToolTipText("Look-up an image by browsing the docker daemon");
        btnDockerSearch.addSelectionListener((SelectionListener)this.onSearch(txtImage));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)btnDockerSearch);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnDockerSearch)).notUpdatingParticipant()).to(BeanProperties.value((String)"dockerConnection").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Label lblName = new Label(parent, 0);
        lblName.setText("Resource Name: ");
        lblName.setToolTipText("The name used to identify the resources that will support the deployed image.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblName);
        Text txtName = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)txtName);
        ISWTObservableValue nameTextObservable = WidgetProperties.text((int)24).observe((Widget)txtName);
        Binding nameBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)nameTextObservable).validatingAfterConvert((IValidator)new DeployImageNameValidator())).to(BeanProperties.value((String)"name").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private SelectionAdapter onSearch(final Text txtImage) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployImagePage.this.model.getDockerConnection() == null) {
                    MessageDialog.openError((Shell)DeployImagePage.this.getShell(), (String)"A Docker connection must be selected", (String)"You must first select a Docker connection.");
                    return;
                }
                ImageSearch wizard = new ImageSearch(DeployImagePage.this.model.getDockerConnection(), txtImage.getText());
                if (new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)wizard).open() == 0) {
                    DeployImagePage.this.model.setImage(wizard.getSelectedImage());
                }
            }
        };
    }

    private void createDockerConnectionControl(Composite parent, DataBindingContext dbc) {
        Label lblConnection = new Label(parent, 0);
        lblConnection.setText("Docker Connection: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblConnection);
        ComboViewer connectionViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo(connectionViewer.getControl());
        connectionViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        connectionViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider(){

            @Override
            public String getText(Object element) {
                if (!(element instanceof IDockerConnection)) {
                    return "";
                }
                IDockerConnection conn = (IDockerConnection)element;
                return NLS.bind((String)"{0} ({1})", (Object)conn.getName(), (Object)conn.getUri());
            }
        });
        connectionViewer.setInput((Object)BeanProperties.list((String)"dockerConnections").observe((Object)this.model));
        IViewerObservableValue selectedConnectionObservable = ViewerProperties.singleSelection().observe((Viewer)connectionViewer);
        Binding selectedConnectionBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedConnectionObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IDockerConnection.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IDockerConnection) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose Docker connection.");
            }
        })).to(BeanProperties.value((String)"dockerConnection").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedConnectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private void createConnectionControl(Composite parent, DataBindingContext dbc) {
        Label lblConnection = new Label(parent, 0);
        lblConnection.setText("OpenShift Connection: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblConnection);
        ComboViewer connectionViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo(connectionViewer.getControl());
        connectionViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        connectionViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider());
        connectionViewer.setInput((Object)BeanProperties.list((String)"connections").observe((Object)this.model));
        IViewerObservableValue selectedConnectionObservable = ViewerProperties.singleSelection().observe((Viewer)connectionViewer);
        Binding selectedConnectionBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedConnectionObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(Connection.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof Connection) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose an OpenShift connection.");
            }
        })).to(BeanProperties.value((String)"connection").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedConnectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private void createProjectControl(Composite parent, DataBindingContext dbc) {
        Label lblProject = new Label(parent, 0);
        lblProject.setText("OpenShift Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblProject);
        ComboViewer cmboProject = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, 30).applyTo(cmboProject.getControl());
        final OpenShiftExplorerLabelProvider labelProvider = new OpenShiftExplorerLabelProvider();
        cmboProject.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cmboProject.setLabelProvider((IBaseLabelProvider)labelProvider);
        cmboProject.setInput((Object)BeanProperties.list((String)"projects").observe((Object)this.model));
        cmboProject.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return labelProvider.getText(e1).compareTo(labelProvider.getText(e2));
            }
        });
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)cmboProject);
        Binding selectedProjectBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IProject.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose an OpenShift project.");
            }
        })).to(BeanProperties.value((String)"project").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        StyledText manageProjectsLink = StyledTextUtils.emulateLinkWidget((String)"<a>Manage Projects</a>", (StyledText)new StyledText(parent, 64));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).indent(8, 0).applyTo((Control)manageProjectsLink);
        StyledTextUtils.emulateLinkAction((StyledText)manageProjectsLink, r -> this.onManageProjectsClicked());
    }

    private void onManageProjectsClicked() {
        try {
            WizardUtils.runInWizard((Job)new UIUpdatingJob("Opening projects wizard..."){

                protected IStatus run(IProgressMonitor monitor) {
                    return Status.OK_STATUS;
                }

                protected IStatus updateUI(IProgressMonitor monitor) {
                    IProject selectedProject;
                    ManageProjectsWizard manageProjectsWizard = new ManageProjectsWizard((Connection)DeployImagePage.this.model.getConnection());
                    int result = new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)manageProjectsWizard).open();
                    if (manageProjectsWizard.hasChanged()) {
                        DeployImagePage.this.model.setProjects(manageProjectsWizard.getProjects());
                    }
                    if (result == 0 && (selectedProject = manageProjectsWizard.getSelectedProject()) != null) {
                        DeployImagePage.this.model.setProject(selectedProject);
                    }
                    return Status.OK_STATUS;
                }
            }, (IWizardContainer)this.getContainer());
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }
}

