/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.X509CertificateParser;

public class SSLCertificateUIHelper {
    public void createTextAndStyle(X509Certificate certificate, StringBuilder builder, List<StyleRange> styles) {
        if (certificate == null) {
            return;
        }
        X509CertificateParser certificateParser = new X509CertificateParser(certificate);
        this.createTextAndStyle(certificateParser.getIssuer(), certificateParser.getValidity(), certificateParser.getFingerprint(), builder, styles);
    }

    public void writeCertificate(X509Certificate certificate, StyledText styledText) {
        if (certificate == null) {
            return;
        }
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        this.createTextAndStyle(certificate, builder, styles);
        styledText.setText(builder.toString());
        this.setStyleRanges(styledText, styles);
    }

    public void writeCertificate(String issuedBy, String validity, String fingerprint, StyledText styledText) {
        this.clean(styledText);
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        this.createTextAndStyle(issuedBy, validity, fingerprint, builder, styles);
        styledText.setText(builder.toString());
        this.setStyleRanges(styledText, styles);
    }

    public void clean(StyledText styledText) {
        this.setStyleRanges(styledText, new ArrayList<StyleRange>());
        styledText.setText("");
    }

    public void createTextAndStyle(String issuedBy, String validity, String fingerprint, StringBuilder builder, List<StyleRange> styles) {
        this.appendLabeledValue("Issued By:\n", issuedBy, builder, styles);
        this.appendLabeledValue("Validity:\n", validity, builder, styles);
        this.appendLabeledValue("SHA1 Fingerprint:\n", fingerprint, builder, styles);
    }

    private void appendLabeledValue(String label, String value, StringBuilder builder, List<StyleRange> styles) {
        this.appendLabel(label, builder, styles);
        this.appendValue(value, builder);
    }

    private void appendValue(String value, StringBuilder builder) {
        builder.append(value).append(StringUtils.getLineSeparator()).append(StringUtils.getLineSeparator());
    }

    private void appendLabel(String label, StringBuilder builder, List<StyleRange> styles) {
        StyleRange styleRange = this.startBoldStyleRange(builder);
        builder.append(label);
        this.finishBoldStyleRange(builder, styleRange);
        styles.add(styleRange);
    }

    private StyleRange startBoldStyleRange(StringBuilder builder) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = builder.length();
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private StyleRange finishBoldStyleRange(StringBuilder builder, StyleRange styleRange) {
        styleRange.length = builder.length() - styleRange.start;
        return styleRange;
    }

    private void setStyleRanges(StyledText logText, List<StyleRange> styles) {
        for (StyleRange style : styles) {
            logText.setStyleRange(style);
        }
    }
}

