/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import com.openshift.restclient.ISSLCertificateCallback;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.preferences.SSLCertificatesPreference;
import org.jboss.tools.openshift.internal.ui.wizard.connection.SSLCertificateUIHelper;

public class SSLCertificateCallback
implements ISSLCertificateCallback {
    private static final boolean REMEMBER_DECISION_DEFAULT = true;
    private boolean rememberDecision = true;

    public boolean allowCertificate(X509Certificate[] certificateChain) {
        Boolean result = SSLCertificatesPreference.getInstance().getAllowedByCertificate(certificateChain[0]);
        if (result != null) {
            return result;
        }
        boolean allow = this.openCertificateDialog(certificateChain);
        if (this.rememberDecision) {
            SSLCertificatesPreference.getInstance().setAllowedByCertificate(certificateChain[0], allow);
        }
        return allow;
    }

    protected boolean openCertificateDialog(final X509Certificate[] certificateChain) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                atomicBoolean.set(new SSLCertificateDialog(UIUtils.getShell(), certificateChain).open() == 0);
            }
        });
        return atomicBoolean.get();
    }

    public boolean allowHostname(String hostname, SSLSession sslSession) {
        return true;
    }

    private class SSLCertificateDialog
    extends TitleAreaDialog {
        private X509Certificate[] certificateChain;
        SSLCertificateUIHelper certificateUIHelper;

        private SSLCertificateDialog(Shell parentShell, X509Certificate[] certificateChain) {
            super(parentShell);
            this.certificateUIHelper = new SSLCertificateUIHelper();
            this.certificateChain = certificateChain;
            this.setHelpAvailable(false);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.setupDialog(parent);
            return control;
        }

        private void setupDialog(Composite parent) {
            parent.getShell().setText("Untrusted SSL Certificate");
            this.setTitle("Do you accept the following untrusted SSL certificate?");
            this.setTitleImage(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
            Label separator = new Label(container, 258);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)separator);
            StyledText certificateText = new StyledText(container, 2624);
            certificateText.setEditable(false);
            GridDataFactory.fillDefaults().align(4, 4).grab(false, true).hint(400, -1).applyTo((Control)certificateText);
            this.writeCertificate(this.certificateChain, certificateText);
            Button rememberCheckbox = new Button(container, 32);
            rememberCheckbox.setText("Remember decision (it can be changed in preferences 'OpenShift 3/SSL certificates')");
            rememberCheckbox.setSelection(SSLCertificateCallback.this.rememberDecision);
            rememberCheckbox.addSelectionListener(this.onRememberCertificate(this.certificateChain[0]));
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)rememberCheckbox);
            return container;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
        }

        private void writeCertificate(X509Certificate[] certificateChain, StyledText styledText) {
            if (certificateChain == null || certificateChain.length == 0) {
                return;
            }
            this.certificateUIHelper.writeCertificate(certificateChain[0], styledText);
        }

        private SelectionListener onRememberCertificate(X509Certificate certificate) {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button rememberCheckbox = (Button)e.getSource();
                    if (rememberCheckbox != null) {
                        SSLCertificateCallback.this.rememberDecision = rememberCheckbox.getSelection();
                    }
                }
            };
        }
    }
}

