/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.connection.IConnectionEditorDetailView;

public class OAuthDetailView
extends BaseDetailsView
implements IConnectionEditorDetailView {
    private static final String MSG_TOKEN = "Enter a token or <a>retrieve</a> a new one.";
    private IObservableValue tokenObservable;
    private Binding tokenBinding;
    private Text tokenText;
    private IValueChangeListener changeListener;
    private IObservableValue rememberTokenObservable;
    private IObservableValue authSchemeObservable;
    private IAuthorizationDetails authDetails;
    private ConnectionWizardPageModel pageModel;
    private Button rememberTokenCheckbox;
    private IWizard wizard;

    public OAuthDetailView(IWizard wizard, ConnectionWizardPageModel pageModel, IValueChangeListener changeListener, Object context, IObservableValue rememberTokenObservable, Button rememberTokenCheckbox, IObservableValue authSchemeObservable) {
        this.wizard = wizard;
        this.pageModel = pageModel;
        this.rememberTokenObservable = rememberTokenObservable;
        this.authSchemeObservable = authSchemeObservable;
        this.changeListener = changeListener;
        this.rememberTokenCheckbox = rememberTokenCheckbox;
        if (context instanceof IAuthorizationDetails) {
            this.authDetails = (IAuthorizationDetails)context;
        }
    }

    public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 10).applyTo(composite);
        StyledText tokenRequestLink = StyledTextUtils.emulateLinkWidget((String)MSG_TOKEN, (StyledText)new StyledText(composite, 64));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)tokenRequestLink);
        if (this.authDetails != null) {
            this.authDetails.getRequestTokenLink();
        }
        StyledTextUtils.emulateLinkAction((StyledText)tokenRequestLink, r -> this.onRetrieveLinkClicked(tokenRequestLink.getShell()));
        tokenRequestLink.setCursor(new Cursor((Device)tokenRequestLink.getShell().getDisplay(), 21));
        Label authTypeLabel = new Label(composite, 0);
        authTypeLabel.setText("Token");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)authTypeLabel);
        this.tokenText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.tokenText);
        this.tokenObservable = new WritableValue(null, String.class);
        return composite;
    }

    public void onVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        this.bindWidgetsToInternalModel(dbc);
        this.rememberTokenCheckbox.setText("&Save token (could trigger secure storage login)");
    }

    public void onInVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        this.dispose();
    }

    public void dispose() {
        DataBindingUtils.dispose((ValidationStatusProvider)this.tokenBinding);
    }

    private void bindWidgetsToInternalModel(DataBindingContext dbc) {
        this.tokenBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tokenText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new RequiredStringValidator("token"))).to(this.tokenObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.tokenBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        this.tokenObservable.addValueChangeListener(this.changeListener);
    }

    @Override
    public void setSelectedConnection(IConnection selectedConnection) {
        if (selectedConnection instanceof Connection) {
            Connection connection = (Connection)selectedConnection;
            this.tokenObservable.setValue((Object)connection.getToken());
            this.rememberTokenObservable.setValue((Object)connection.isRememberToken());
        } else if (selectedConnection instanceof NewConnectionMarker) {
            this.tokenObservable.setValue(null);
            this.rememberTokenObservable.setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public ConnectionWizardPageModel.IConnectionAuthenticationProvider getConnectionAuthenticationProvider() {
        return new BearTokenAuthenticationProvider();
    }

    public boolean isViewFor(Object object) {
        return object == this;
    }

    public String toString() {
        return "OAuth";
    }

    private void onRetrieveLinkClicked(final Shell shell) {
        if (StringUtils.isBlank((String)this.pageModel.getHost())) {
            return;
        }
        AuthDetailsJob job = new AuthDetailsJob(this.pageModel.getHost());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                if (event.getJob() instanceof AuthDetailsJob) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AuthDetailsJob job = (AuthDetailsJob)event.getJob();
                            IAuthorizationDetails details = job.getDetails();
                            if (details != null) {
                                if ("Basic".equals(details.getScheme())) {
                                    MessageDialog.openError((Shell)shell, (String)"Authorization Information", (String)NLS.bind((String)"This server utilizes {0} authorization protocol", (Object)details.getScheme()));
                                    OAuthDetailView.this.authSchemeObservable.setValue((Object)details.getScheme());
                                } else if ("cocoa".equals(Platform.getWS())) {
                                    new BrowserUtility().checkedCreateExternalBrowser(details.getRequestTokenLink(), "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
                                } else {
                                    OAuthDialog dialog = new OAuthDialog(shell, details.getRequestTokenLink());
                                    job.addJobChangeListener(dialog);
                                    dialog.open();
                                }
                            }
                        }
                    });
                }
            }
        });
        try {
            WizardUtils.runInWizard((Job)job, (IWizardContainer)this.wizard.getContainer());
        }
        catch (InterruptedException | InvocationTargetException ex) {
            this.showErrorDialog(shell, ex);
        }
    }

    private void showErrorDialog(final Shell shell, final Throwable e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)shell, (String)"Request Authentication Details Error", (String)"Unable to retrieve authentication details", (IStatus)ValidationStatus.error((String)e.getMessage(), (Throwable)e));
            }
        });
    }

    private class AuthDetailsJob
    extends Job {
        private IAuthorizationDetails details;
        private String host;

        public AuthDetailsJob(String host) {
            super(NLS.bind((String)"Retrieve authorization details from {0}...", (Object)host));
            this.host = host;
        }

        public IAuthorizationDetails getDetails() {
            return this.details;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IClient client = new ClientFactory().create(this.host, OpenShiftCoreUIIntegration.getInstance().getSSLCertificateCallback());
                this.details = client.getAuthorizationDetails(this.host);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ConnectTimeoutException) {
                    return new Status(4, "org.jboss.tools.openshift.ui", "Timed out waiting for a response for authorization details.\nThis server might be unavailable or may not support OAuth.", (Throwable)e);
                }
                return new Status(4, "org.jboss.tools.openshift.ui", "Unable to retrieve the authentication details", (Throwable)e);
            }
            return ValidationStatus.OK_STATUS;
        }
    }

    private class BearTokenAuthenticationProvider
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private BearTokenAuthenticationProvider() {
        }

        public IConnection update(IConnection conn) {
            Assert.isLegal((boolean)(conn instanceof Connection));
            final Connection connection = (Connection)conn;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    connection.setAuthScheme("OAuth");
                    connection.setToken((String)OAuthDetailView.this.tokenObservable.getValue());
                    connection.setRememberToken(((Boolean)OAuthDetailView.this.rememberTokenObservable.getValue()).booleanValue());
                }
            });
            return connection;
        }
    }

    private class OAuthDialog
    extends Dialog
    implements IJobChangeListener {
        private String loadingHtml;
        private String url;
        private Browser browser;

        OAuthDialog(Shell parentShell, String url) {
            super(parentShell);
            this.url = url;
            try {
                this.loadingHtml = IOUtils.toString((InputStream)OpenShiftUIActivator.getDefault().getPluginFile("html/spinner.html"));
            }
            catch (Exception exception) {
                this.loadingHtml = "Loading...";
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Close", true);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return new Point(500, 700);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
            this.browser = new Browser(container, 2048);
            this.browser.setText(this.loadingHtml);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.browser);
            final ProgressBar progressBar = new ProgressBar(container, 0);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)progressBar);
            ProgressListener progressListener = new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total <= 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                }

                public void completed(ProgressEvent event) {
                    progressBar.setSelection(0);
                }
            };
            this.browser.addProgressListener(progressListener);
            this.setURL(this.url);
            return container;
        }

        public void setURL(String url) {
            if (StringUtils.isNotBlank((String)url)) {
                this.url = url;
                this.browser.setUrl(url);
            }
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(final IJobChangeEvent event) {
            if (event.getJob() instanceof AuthDetailsJob) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AuthDetailsJob job = (AuthDetailsJob)event.getJob();
                        IAuthorizationDetails details = job.getDetails();
                        if (details != null) {
                            OAuthDialog.this.setURL(details.getRequestTokenLink());
                        } else {
                            IStatus result = job.getResult();
                            OAuthDetailView.this.showErrorDialog(OAuthDialog.this.getShell(), result.getException());
                            OAuthDialog.this.close();
                        }
                    }
                });
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

