/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionFactory;
import org.jboss.tools.openshift.internal.common.ui.connection.BaseConnectionEditor;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNullValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.ui.wizard.connection.BasicAuthenticationDetailView;
import org.jboss.tools.openshift.internal.ui.wizard.connection.IConnectionEditorDetailView;
import org.jboss.tools.openshift.internal.ui.wizard.connection.OAuthDetailView;

public class ConnectionEditor
extends BaseConnectionEditor {
    private static final String PROPERTY_SELECTED_DETAIL_VIEW = "selectedDetailView";
    private Map<String, IConnectionEditorDetailView> detailViews = new HashMap<String, IConnectionEditorDetailView>();
    private ConnectionEditorStackedDetailViews stackedViews;
    private DetailViewModel detailViewModel = new DetailViewModel();
    private Button rememberTokenCheckbox;
    private ComboViewer authTypeViewer;
    private IObservableValue rememberTokenObservable;
    private IObservableValue detailViewObservable;
    private IObservableValue authSchemeObservable;
    private Binding rememberTokenBinding;
    private Binding selectedAuthTypeBinding;

    public Composite createControls(Composite parent, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(composite);
        this.rememberTokenObservable = new WritableValue((Object)Boolean.FALSE, Boolean.class);
        this.rememberTokenCheckbox = new Button(parent, 32);
        this.detailViewObservable = BeanProperties.value((String)PROPERTY_SELECTED_DETAIL_VIEW, IConnectionEditorDetailView.class).observe((Object)this.detailViewModel);
        this.authSchemeObservable = BeanProperties.value((String)"authScheme", String.class).observe((Object)this.detailViewModel);
        this.detailViews.put("OAuth", new OAuthDetailView(this.wizardPage.getWizard(), pageModel, this.changeListener, pageModel.getContext(), this.rememberTokenObservable, this.rememberTokenCheckbox, this.authSchemeObservable));
        this.detailViews.put("Basic", new BasicAuthenticationDetailView(this.changeListener, pageModel.getContext(), this.rememberTokenObservable, this.rememberTokenCheckbox));
        Label authTypeLabel = new Label(composite, 0);
        authTypeLabel.setText("Protocol:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)authTypeLabel);
        Combo authTypeCombo = new Combo(composite, -1);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)authTypeCombo);
        this.authTypeViewer = new ComboViewer(authTypeCombo);
        this.authTypeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.authTypeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.authTypeViewer.setInput(this.detailViews.values());
        Composite detailsContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).applyTo((Control)detailsContainer);
        this.stackedViews = new ConnectionEditorStackedDetailViews(this.detailViewObservable, pageModel, detailsContainer, dbc);
        this.stackedViews.createControls(false);
        this.rememberTokenCheckbox.setParent(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.rememberTokenCheckbox);
        return composite;
    }

    public void onVisible(IObservableValue detailViewModelObservable, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.bindWidgetsToInternalModel(dbc);
        this.detailViewModel.setSelectedConnection(pageModel.getSelectedConnection());
    }

    public void onInVisible(IObservableValue detailViewModelObservable, DataBindingContext dbc) {
        this.detailViewModel.getSelectedDetailView().onInVisible(detailViewModelObservable, dbc);
        this.disposeBindings();
    }

    private void bindWidgetsToInternalModel(DataBindingContext dbc) {
        this.selectedAuthTypeBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.authTypeViewer)).validatingAfterGet((IValidator)new IsNotNullValidator(ValidationStatus.cancel((String)"Please select an authorization protocol.")))).to(this.detailViewObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.selectedAuthTypeBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        this.rememberTokenBinding = ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)this.rememberTokenCheckbox)).to(this.rememberTokenObservable).in(dbc);
    }

    public void onInVisible(IObservableValue detailsViewModelObservable, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.detailViewModel.getSelectedDetailView().onInVisible(detailsViewModelObservable, dbc);
        this.disposeBindings();
    }

    private void disposeBindings() {
        DataBindingUtils.dispose((ValidationStatusProvider)this.rememberTokenBinding);
        DataBindingUtils.dispose((ValidationStatusProvider)this.selectedAuthTypeBinding);
        AbstractStackedDetailViews.IDetailView[] iDetailViewArray = this.stackedViews.getDetailViews();
        int n = iDetailViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractStackedDetailViews.IDetailView view = iDetailViewArray[n2];
            view.dispose();
            ++n2;
        }
    }

    protected void onSelectedConnectionChanged(IObservableValue selectedConnection) {
        IConnection conn = (IConnection)selectedConnection.getValue();
        this.detailViewModel.setSelectedConnection(conn);
    }

    public boolean isViewFor(Object object) {
        return object instanceof ConnectionFactory;
    }

    private IConnectionEditorDetailView getDetailView() {
        return this.detailViewModel.getSelectedDetailView();
    }

    protected ConnectionWizardPageModel.IConnectionAuthenticationProvider createConnectionAuthenticationProvider(ConnectionWizardPageModel pageModel) {
        return new ConnectionAuthenticationProviderProxy();
    }

    private class ConnectionAuthenticationProviderProxy
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private ConnectionAuthenticationProviderProxy() {
        }

        public IConnection update(IConnection connection) {
            return ConnectionEditor.this.getDetailView().getConnectionAuthenticationProvider().update(connection);
        }
    }

    private class ConnectionEditorStackedDetailViews
    extends AbstractStackedDetailViews {
        public ConnectionEditorStackedDetailViews(IObservableValue detailViewModel, Object context, Composite parent, DataBindingContext dbc) {
            super(detailViewModel, context, parent, dbc);
        }

        protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
            return ConnectionEditor.this.detailViews.values().toArray(new IConnectionEditorDetailView[ConnectionEditor.this.detailViews.size()]);
        }
    }

    private class DetailViewModel
    extends ObservablePojo {
        private IConnectionEditorDetailView selectedDetailView;

        private DetailViewModel() {
        }

        public IConnectionEditorDetailView getSelectedDetailView() {
            return this.selectedDetailView;
        }

        public void setSelectedDetailView(IConnectionEditorDetailView view) {
            this.selectedDetailView = view;
        }

        public void setAuthScheme(String scheme) {
            ConnectionEditor.this.detailViewObservable.setValue(ConnectionEditor.this.detailViews.get(scheme));
        }

        public void setSelectedConnection(IConnection conn) {
            if (conn instanceof Connection) {
                Connection connection = (Connection)conn;
                ConnectionEditor.this.detailViewObservable.setValue(ConnectionEditor.this.detailViews.get(connection.getAuthScheme()));
            } else {
                ConnectionEditor.this.rememberTokenObservable.setValue((Object)Boolean.FALSE);
                ConnectionEditor.this.detailViewObservable.setValue(ConnectionEditor.this.detailViews.get("OAuth"));
            }
            for (IConnectionEditorDetailView view : ConnectionEditor.this.detailViews.values()) {
                view.setSelectedConnection(conn);
            }
        }
    }
}

