/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.webhooks;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.build.IWebhookTrigger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.webhooks.WebhookUtil;

public class WebHooksComponent
extends Composite {
    private static final int COPIED_NOTIFICATION_SHOW_DURATION = 2000;
    protected static final String WEBHOOKS_DOCS = "https://docs.openshift.org/latest/dev_guide/builds.html#webhook-triggers";
    private Collection<IBuildConfig> buildConfigs;

    public WebHooksComponent(IBuildConfig buildConfig, Composite parent, int style) {
        super(parent, style);
        this.buildConfigs = Collections.singleton(buildConfig);
        this.createControls(this.buildConfigs, parent);
    }

    public WebHooksComponent(Collection<IBuildConfig> buildConfigs, Composite parent, int style) {
        super(parent, style);
        this.buildConfigs = buildConfigs;
        this.createControls(buildConfigs, parent);
    }

    private void createControls(Collection<IBuildConfig> buildConfigs, Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        Link webhookExplanation = new Link((Composite)this, 64);
        webhookExplanation.setText("<a>Webhook triggers</a> allow you to trigger a new build by sending a request to the OpenShift API endpoint.");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)webhookExplanation);
        webhookExplanation.addSelectionListener(this.onWebhookExplanationClicked());
        for (IBuildConfig buildConfig : buildConfigs) {
            Group hooksGroup = new Group((Composite)this, 0);
            hooksGroup.setText("Webhooks for " + buildConfig.getSourceURI());
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)hooksGroup);
            GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo((Composite)hooksGroup);
            this.createHookWidgets(buildConfig, (Composite)hooksGroup);
        }
    }

    private SelectionListener onWebhookExplanationClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateExternalBrowser(WebHooksComponent.WEBHOOKS_DOCS, "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
            }
        };
    }

    private void createHookWidgets(IBuildConfig buildConfig, Composite parent) {
        List<IWebhookTrigger> webHooks = WebhookUtil.getWebHooks(buildConfig);
        if (webHooks == null || webHooks.isEmpty()) {
            this.createNoHooksMessage(buildConfig, parent);
        } else {
            for (IWebhookTrigger webHook : webHooks) {
                this.createWebhookWidget(buildConfig, webHook, parent);
            }
        }
    }

    private void createNoHooksMessage(IBuildConfig buildConfig, Composite parent) {
        Label noHooksLabel = new Label(parent, 0);
        noHooksLabel.setText("You have no webhooks configured for build config. " + buildConfig.getSourceURI());
    }

    private void createWebhookWidget(IBuildConfig buildConfig, IWebhookTrigger webHook, Composite parent) {
        Link link = new Link(parent, 0);
        link.addSelectionListener((SelectionListener)this.onClickWebhook(buildConfig));
        String gitUrl = buildConfig.getSourceURI();
        String linkLabel = WebHooksComponent.isGitHub(gitUrl, webHook) ? "<a>" + webHook.getType() + "</a>" : webHook.getType();
        link.setText(String.valueOf(linkLabel) + " webhook:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)link);
        Text uriText = new Text(parent, 2048);
        uriText.setEditable(false);
        uriText.setText(webHook.getWebhookURL());
        uriText.addMouseListener((MouseListener)this.onClickUriText(uriText));
        uriText.setToolTipText("Click to copy to the clipboard");
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)uriText);
        Button copyToClipboard = new Button(parent, 8);
        copyToClipboard.setImage(OpenShiftImages.COPY_TO_CLIPBOARD_IMG);
        copyToClipboard.setToolTipText("Copy to clipboard");
        copyToClipboard.addSelectionListener((SelectionListener)this.onClickCopyButton(uriText));
    }

    private SelectionAdapter onClickCopyButton(final Text uriText) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebHooksComponent.this.copyToClipBoard(uriText);
            }
        };
    }

    private MouseAdapter onClickUriText(final Text uriText) {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                WebHooksComponent.this.copyToClipBoard(uriText);
            }
        };
    }

    private SelectionAdapter onClickWebhook(final IBuildConfig buildConfig) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = buildConfig.getBuildSource().getURI();
                if (WebHooksComponent.isGitHub(url = StringUtils.removeEnd((String)url, (String)".git"))) {
                    if (!url.endsWith("/")) {
                        url = String.valueOf(url) + "/";
                    }
                    url = String.valueOf(url) + "settings/hooks";
                }
                new BrowserUtility().checkedCreateExternalBrowser(url, "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
            }
        };
    }

    private void copyToClipBoard(Text uriText) {
        uriText.selectAll();
        String uriToCopy = uriText.getText();
        this.copyToClipBoard(uriToCopy);
        this.notifyCopied(uriText);
    }

    private void notifyCopied(Text uriText) {
        DefaultToolTip copiedNotification = new DefaultToolTip((Control)uriText, 2, true);
        copiedNotification.setText("Webhook copied to clipboard");
        copiedNotification.setHideDelay(2000);
        copiedNotification.show(uriText.getLocation());
        copiedNotification.deactivate();
    }

    private static boolean isGitHub(String gitUrl, IWebhookTrigger webHook) {
        if (!WebHooksComponent.isGitHub(gitUrl)) {
            return false;
        }
        switch (webHook.getType()) {
            case "github": 
            case "GitHub": {
                return true;
            }
        }
        return false;
    }

    private static boolean isGitHub(String gitUrl) {
        return StringUtils.startsWith((String)gitUrl, (String)"https://github.com/");
    }

    private void copyToClipBoard(String url) {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        Object[] data = new Object[]{url};
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(data, dataTypes);
        clipboard.dispose();
    }
}

