/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class LabelValueValidator
implements IValidator {
    public static final int LABEL_MAXLENGTH = 63;
    private static final Pattern LABEL_REGEXP = Pattern.compile("^(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])?$");
    private final String failureMessage = "A valid {0} must be 63 characters or less and must begin and end with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.";
    private final IStatus FAILED;
    protected String type;

    public LabelValueValidator() {
        this("label value");
    }

    public LabelValueValidator(String element) {
        this.type = element;
        this.FAILED = ValidationStatus.error((String)NLS.bind((String)"A valid {0} must be 63 characters or less and must begin and end with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.", (Object)this.type));
    }

    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)NLS.bind((String)"{0} is not an instance of a string", (Object)this.type));
        }
        String value = (String)paramObject;
        if (StringUtils.isBlank((String)value)) {
            return this.getPatternConstraintError();
        }
        if (value.length() > 63) {
            return this.getSizeConstraintError();
        }
        if (!LABEL_REGEXP.matcher(value).matches()) {
            return this.getPatternConstraintError();
        }
        return ValidationStatus.OK_STATUS;
    }

    protected boolean validateLabel(String value) {
        if (value.length() > 63) {
            return false;
        }
        return LABEL_REGEXP.matcher(value).matches();
    }

    protected IStatus getSizeConstraintError() {
        return ValidationStatus.error((String)NLS.bind((String)"Maximum length allowed is {0} characters for {1}", (Object)63, (Object)this.type));
    }

    protected IStatus getPatternConstraintError() {
        return this.getFailedStatus();
    }

    protected IStatus getFailedStatus() {
        return this.FAILED;
    }
}

