/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.treeitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;

public class ObservableTreeItem
extends ObservableUIPojo {
    public static final String PROPERTY_CHILDREN = "children";
    private List<ObservableTreeItem> children;
    private Object model;
    private IModelFactory factory;

    public ObservableTreeItem(Object model) {
        this(model, null);
    }

    public ObservableTreeItem(Object model, IModelFactory factory) {
        this.model = model;
        this.factory = factory;
    }

    public List<ObservableTreeItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<ObservableTreeItem> children) {
        this.children = children;
        this.firePropertyChange(PROPERTY_CHILDREN, this.children, this.children);
    }

    public Object getModel() {
        return this.model;
    }

    public void load() {
        List<ObservableTreeItem> children = this.createTreeItems(this.loadChildren());
        this.setChildren(children);
        for (ObservableTreeItem item : children) {
            item.load();
        }
    }

    public boolean isLoaded() {
        return this.children != null;
    }

    protected List<? extends Object> loadChildren() {
        if (this.factory != null) {
            return this.factory.createChildren(this.model);
        }
        return Collections.emptyList();
    }

    protected List<ObservableTreeItem> createTreeItems(List<?> children) {
        ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
        for (Object child : children) {
            ObservableTreeItem childItem = this.createChildItem(child);
            if (childItem == null) continue;
            items.add(childItem);
        }
        return items;
    }

    protected ObservableTreeItem createChildItem(Object model) {
        return new ObservableTreeItem(model, this.factory);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservableTreeItem)) {
            return false;
        }
        ObservableTreeItem other = (ObservableTreeItem)((Object)obj);
        return !(this.model == null ? other.model != null : !this.model.equals(other.model));
    }
}

