/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ServiceViewerFilter
extends ViewerFilter {
    private Text filterText;

    public ServiceViewerFilter(Text filterText) {
        Assert.isLegal((!DisposeUtils.isDisposed((Control)filterText) ? 1 : 0) != 0);
        this.filterText = filterText;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof ObservableTreeItem)) {
            return false;
        }
        if (!(((ObservableTreeItem)((Object)element)).getModel() instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)((ObservableTreeItem)((Object)element)).getModel();
        if (resource instanceof IService) {
            return this.isMatching(this.filterText.getText(), (IService)resource);
        }
        return true;
    }

    private boolean isMatching(String filter, IService service) {
        for (String label : service.getSelector().values()) {
            if (StringUtils.isEmpty((String)label) || !label.contains(filter)) continue;
            return true;
        }
        return false;
    }
}

