/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.SelectExistingProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.databinding.FormPresenterSupport;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.server.OpenShiftServerTaskModelAccessor;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsViewModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceDetailViews;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewerFilter;
import org.jboss.tools.openshift.internal.ui.server.WizardFragmentUtils;
import org.jboss.tools.openshift.internal.ui.server.WizardHandleAwareFragment;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;

public class ServerSettingsWizardFragment
extends WizardHandleAwareFragment
implements DeploymentTypeUIUtil.ICompletable {
    static final String IS_LOADING_SERVICES = "isLoadingServices";
    private ServerSettingsViewModel model;
    private boolean needsLoadingServices = true;
    private PropertyChangeListener connectionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IWizardContainer wizardContainer = ServerSettingsWizardFragment.this.getWizardContainer();
            if (ServerSettingsWizardFragment.this.model == null || wizardContainer == null) {
                return;
            }
            if ("selectedConnection".equals(evt.getPropertyName())) {
                Connection newConnection;
                if ((evt.getNewValue() == null || evt.getNewValue() instanceof Connection) && (newConnection = (Connection)evt.getNewValue()) != ServerSettingsWizardFragment.this.model.getConnection() && wizardContainer != null) {
                    ServerSettingsWizardFragment.this.needsLoadingServices = true;
                    ServerSettingsWizardFragment.this.model.setConnection(newConnection);
                    ServerSettingsWizardFragment.this.model.setServiceItems(new ArrayList<ObservableTreeItem>());
                    ServerSettingsWizardFragment.this.setComplete(false);
                    wizardContainer.updateButtons();
                }
            } else if ("connectedStatus".equals(evt.getPropertyName())) {
                ServerSettingsWizardFragment.this.needsLoadingServices = true;
                ServerSettingsWizardFragment.this.model.setServiceItems(new ArrayList<ObservableTreeItem>());
                ServerSettingsWizardFragment.this.setComplete(false);
                wizardContainer.updateButtons();
            }
        }
    };
    private Control uiHook = null;
    private boolean isLoadingServices = false;

    public ServerSettingsWizardFragment() {
        this.setComplete(false);
    }

    public PropertyChangeListener getConnectionChangeListener() {
        return this.connectionChangeListener;
    }

    public boolean hasComposite() {
        return true;
    }

    @Override
    public Composite createComposite(final Composite parent, final IWizardHandle handle) {
        super.createComposite(parent, handle);
        handle.setTitle("Create an OpenShift 3 Server Adapter");
        handle.setDescription("Create an OpenShift 3 Server Adapter by selecting the project, service and folders used for file synchronization.");
        handle.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
        IServerWorkingCopy server = OpenShiftServerTaskModelAccessor.getServer(this.getTaskModel());
        Connection connection = OpenShiftServerTaskModelAccessor.getConnection(this.getTaskModel());
        this.model = new ServerSettingsViewModel(server, connection);
        DataBindingContext dbc = new DataBindingContext();
        Composite composite = this.createControls(parent, this.model, dbc);
        this.uiHook = composite.getChildren()[0];
        this.isLoadingServices = false;
        new FormPresenterSupport(new FormPresenterSupport.IFormPresenter(){

            public void setMessage(String message, int type) {
                WizardFragmentUtils.getWizardPage(handle).setMessage(message, type);
            }

            public void setComplete(boolean complete) {
                WizardFragmentUtils.getWizardPage(handle).setPageComplete(complete);
                ServerSettingsWizardFragment.this.setComplete(complete);
                handle.update();
            }

            public Control getControl() {
                return parent;
            }
        }, dbc);
        this.loadResources(this.model, WizardFragmentUtils.getWizardPage(handle).getWizard().getContainer());
        IProject selectedProject = UIUtils.getFirstSelectedWorkbenchProject();
        if (selectedProject != null) {
            this.model.setDeployProject(selectedProject);
        }
        ((WizardDialog)((WizardPage)handle).getWizard().getContainer()).addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getTargetPage() == handle) {
                    ServerSettingsWizardFragment.this.reloadServices();
                }
            }
        });
        return composite;
    }

    private Composite createControls(Composite parent, ServerSettingsViewModel model, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 10).applyTo(container);
        this.createProjectControls(container, model, dbc);
        this.createSourcePathControls(container, model, dbc);
        this.createDeploymentControls(container, model, dbc);
        this.createServiceControls(container, model, dbc);
        return container;
    }

    private void createProjectControls(Composite container, ServerSettingsViewModel model, DataBindingContext dbc) {
        Label projectLabel = new Label(container, 0);
        projectLabel.setText("Eclipse Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)projectLabel);
        ComboViewer projectsViewer = new ComboViewer(container);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo(projectsViewer.getControl());
        projectsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IProject)) {
                    return null;
                }
                return ((IProject)element).getName();
            }
        });
        projectsViewer.setInput((Object)BeanProperties.list((String)"projects").observe((Object)model));
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)projectsViewer);
        Binding selectedProjectBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose a project to deploy.");
            }
        })).to(BeanProperties.value((String)"deployProject").observe((Object)model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button browseProjectsButton = new Button(container, 0);
        browseProjectsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)browseProjectsButton);
        browseProjectsButton.addSelectionListener(this.onBrowseProjects(model, browseProjectsButton.getShell()));
    }

    private SelectionListener onBrowseProjects(final ServerSettingsViewModel model, final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedProject;
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog("Select a project to deploy", shell);
                if (dialog.open() == 0 && (selectedProject = dialog.getFirstResult()) instanceof IProject) {
                    model.setDeployProject((IProject)selectedProject);
                }
            }
        };
    }

    private void createSourcePathControls(Composite container, ServerSettingsViewModel model2, DataBindingContext dbc) {
        Label sourcePathLabel = new Label(container, 0);
        sourcePathLabel.setText("Source Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sourcePathLabel);
        Text sourcePathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sourcePathText);
        Binding sourcePathBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)sourcePathText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                String path = (String)value;
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((Object)value)) {
                    return ValidationStatus.cancel((String)"Please provide a local path to deploy from.");
                }
                if (!this.isValidSource(path)) {
                    return ValidationStatus.error((String)"Please provide a valid local path to deploy from.");
                }
                return ValidationStatus.ok();
            }

            private boolean isValidSource(String path) {
                return new File(path).canRead();
            }
        })).to(BeanProperties.value((String)"sourcePath").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)sourcePathBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button browseSourceButton = new Button(container, 8);
        browseSourceButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseSourceButton);
        browseSourceButton.addSelectionListener((SelectionListener)this.onBrowseSource(browseSourceButton.getShell()));
        Button browseWorkspaceSourceButton = new Button(container, 8);
        browseWorkspaceSourceButton.setText("Workspace...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseWorkspaceSourceButton);
        browseWorkspaceSourceButton.addSelectionListener((SelectionListener)this.onBrowseWorkspace(browseWorkspaceSourceButton.getShell()));
    }

    private SelectionAdapter onBrowseSource(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setText("Choose the source path to sync");
                String sourcePath = VariablesHelper.replaceVariables((String)ServerSettingsWizardFragment.this.model.getSourcePath(), (boolean)true);
                dialog.setFilterPath(sourcePath);
                String filepath = dialog.open();
                if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)filepath)) {
                    ServerSettingsWizardFragment.this.model.setSourcePath(filepath);
                }
            }
        };
    }

    private SelectionAdapter onBrowseWorkspace(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourcePath = ServerSettingsWizardFragment.this.getWorkspaceRelativePath(ServerSettingsWizardFragment.this.model.getSourcePath());
                ElementTreeSelectionDialog dialog = ServerSettingsWizardFragment.this.createWorkspaceFolderDialog(shell, sourcePath);
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IContainer) {
                    String path = ((IContainer)dialog.getFirstResult()).getFullPath().toString();
                    String folderPath = VariablesHelper.addWorkspacePrefix((String)path);
                    ServerSettingsWizardFragment.this.model.setSourcePath(folderPath);
                }
            }
        };
    }

    private String getWorkspaceRelativePath(String sourcePath) {
        if (StringUtils.isBlank((String)sourcePath) || sourcePath.contains("{")) {
            return sourcePath;
        }
        Path absolutePath = new Path(sourcePath);
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)absolutePath);
        if (container != null) {
            return container.getFullPath().toString();
        }
        return null;
    }

    private ElementTreeSelectionDialog createWorkspaceFolderDialog(Shell shell, String selectedFile) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select a workspace folder");
        dialog.setMessage("Select a workspace folder to deploy");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IContainer)) {
                    return false;
                }
                IContainer container = (IContainer)element;
                return container.isAccessible() && !ProjectUtils.isInternalPde((String)container.getName()) && !ProjectUtils.isInternalRSE((String)container.getName());
            }
        });
        dialog.setAllowMultiple(false);
        IProject res = this.model.getDeployProject();
        if (StringUtils.isNotBlank((String)selectedFile)) {
            String path = VariablesHelper.getWorkspacePath((String)selectedFile);
            org.eclipse.core.resources.IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (member != null) {
                res = member;
            }
        }
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        return dialog;
    }

    private void createDeploymentControls(Composite container, ServerSettingsViewModel model, DataBindingContext dbc) {
        Label deployPathLabel = new Label(container, 0);
        deployPathLabel.setText("Pod Deployment Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)deployPathLabel);
        Text deployPathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)deployPathText);
        Binding deployPathBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)deployPathText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                String path = (String)value;
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((Object)value)) {
                    return ValidationStatus.cancel((String)"Please provide a path to deploy to on the pod.");
                }
                if (!Path.isValidPosixPath((String)path)) {
                    return ValidationStatus.error((String)"Please provide a valid path to deploy to on the pod");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"podPath").observe((Object)model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)deployPathBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private void createServiceControls(Composite container, ServerSettingsViewModel model, DataBindingContext dbc) {
        Group servicesGroup = new Group(container, 0);
        servicesGroup.setText("Services");
        GridDataFactory.fillDefaults().span(4, 1).align(4, 4).grab(true, true).applyTo((Control)servicesGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)servicesGroup);
        Label selectorLabel = new Label((Composite)servicesGroup, 0);
        selectorLabel.setText("Selector:");
        Text selectorText = UIUtils.createSearchText((Composite)servicesGroup);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)selectorText);
        TreeViewer servicesViewer = this.createServicesTreeViewer((Composite)servicesGroup, model, selectorText);
        BeanProperties.list((String)"serviceItems").observe((Object)model).addListChangeListener(this.onServiceItemsChanged(servicesViewer));
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).hint(-1, 160).grab(true, true).applyTo(servicesViewer.getControl());
        selectorText.addModifyListener(this.onFilterTextModified(servicesViewer));
        IViewerObservableValue selectedServiceTreeItem = ViewerProperties.singleSelection().observe((Viewer)servicesViewer);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedServiceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter(IService.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof IService)) {
                    return ValidationStatus.cancel((String)"Please select a service that this adapter will be bound to.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"service").observe((Object)model)).converting((IConverter)new Model2ObservableTreeItemConverter(new ServerSettingsViewModel.ServiceTreeItemsFactory()))).in(dbc);
        Label detailsLabel = new Label((Composite)servicesGroup, 0);
        detailsLabel.setText("Service Details:");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).applyTo((Control)detailsLabel);
        Composite detailsContainer = new Composite((Composite)servicesGroup, 0);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).hint(-1, 150).applyTo((Control)detailsContainer);
        WritableValue selectedService = new WritableValue();
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedServiceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter())).to((IObservableValue)selectedService).notUpdatingParticipant()).in(dbc);
        new ServiceDetailViews((IObservableValue)selectedService, detailsContainer, dbc).createControls();
    }

    private IListChangeListener onServiceItemsChanged(final TreeViewer servicesViewer) {
        return new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                servicesViewer.expandAll();
            }
        };
    }

    private TreeViewer createServicesTreeViewer(Composite parent, ServerSettingsViewModel model, Text selectorText) {
        TreeViewer applicationTemplatesViewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"serviceItems"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        applicationTemplatesViewer.setContentProvider((IContentProvider)contentProvider);
        applicationTemplatesViewer.setLabelProvider((IBaseLabelProvider)new ServicesViewLabelProvider());
        applicationTemplatesViewer.addFilter((ViewerFilter)new ServiceViewerFilter(selectorText));
        applicationTemplatesViewer.setAutoExpandLevel(-1);
        applicationTemplatesViewer.setInput((Object)model);
        return applicationTemplatesViewer;
    }

    protected ModifyListener onFilterTextModified(final TreeViewer applicationTemplatesViewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                applicationTemplatesViewer.refresh();
                applicationTemplatesViewer.expandAll();
            }
        };
    }

    private void loadResources(final ServerSettingsViewModel model, IWizardContainer container) {
        try {
            WizardUtils.runInWizard((Job)new Job("Loading projects and services..."){

                protected IStatus run(IProgressMonitor monitor) {
                    model.loadResources();
                    ServerSettingsWizardFragment.this.needsLoadingServices = false;
                    return Status.OK_STATUS;
                }
            }, (IWizardContainer)container);
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    private void reloadServices() {
        if (!this.needsLoadingServices) {
            return;
        }
        IWizardContainer container = this.getWizardContainer();
        if (container == null) {
            return;
        }
        try {
            try {
                this.isLoadingServices = true;
                this.getTaskModel().putObject(IS_LOADING_SERVICES, (Object)this.isLoadingServices);
                container.updateButtons();
                WizardUtils.runInWizard((Job)new Job("Loading services..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        ServerSettingsWizardFragment.this.model.loadResources(ServerSettingsWizardFragment.this.model.getConnection());
                        ServerSettingsWizardFragment.this.needsLoadingServices = false;
                        return Status.OK_STATUS;
                    }
                }, (IWizardContainer)container);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.isLoadingServices = false;
                this.needsLoadingServices = false;
                this.getTaskModel().putObject(IS_LOADING_SERVICES, (Object)this.isLoadingServices);
                container.updateButtons();
            }
        }
        finally {
            this.isLoadingServices = false;
            this.needsLoadingServices = false;
            this.getTaskModel().putObject(IS_LOADING_SERVICES, (Object)this.isLoadingServices);
            container.updateButtons();
        }
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.model.updateServer();
        this.uiHook = null;
        this.model = null;
        super.performFinish(monitor);
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
        this.uiHook = null;
        this.model = null;
        super.performCancel(monitor);
    }

    public void setComplete(boolean complete) {
        super.setComplete(complete);
    }

    public boolean isComplete() {
        return !this.isLoadingServices && this.uiHook != null && !this.uiHook.isDisposed() && !this.needsLoadingServices && this.model.getService() != null && super.isComplete();
    }

    private class ServicesViewLabelProvider
    extends StyledCellLabelProvider {
        private ServicesViewLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof ObservableTreeItem)) {
                return;
            }
            if (!(((ObservableTreeItem)((Object)element)).getModel() instanceof IResource)) {
                return;
            }
            IResource resource = (IResource)((ObservableTreeItem)((Object)element)).getModel();
            StyledString text = new StyledString();
            if (resource instanceof com.openshift.restclient.model.IProject) {
                this.createProjectLabel(text, (com.openshift.restclient.model.IProject)resource);
            } else if (resource instanceof IService) {
                this.createServiceLabel(text, (IService)resource);
            }
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }

        private void createProjectLabel(StyledString text, com.openshift.restclient.model.IProject resource) {
            text.append(resource.getName());
        }

        private void createServiceLabel(StyledString text, IService service) {
            text.append(service.getName());
            String selectorsDecoration = org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)service.getSelector());
            if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)selectorsDecoration)) {
                text.append(" ", StyledString.DECORATIONS_STYLER);
                text.append(selectorsDecoration, StyledString.DECORATIONS_STYLER);
            }
        }
    }
}

