/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.server.ServerUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.core.util.CollectionUtils;
import org.jboss.tools.openshift.internal.ui.models.Deployment;
import org.jboss.tools.openshift.internal.ui.models.DeploymentResourceMapper;
import org.jboss.tools.openshift.internal.ui.models.IProjectAdapter;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewModel;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ServerSettingsViewModel
extends ServiceViewModel {
    public static final String PROPERTY_DEPLOYPROJECT = "deployProject";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_SOURCE_PATH = "sourcePath";
    public static final String PROPERTY_POD_PATH = "podPath";
    private static final Pattern PATTERN_REDHAT_DEPLOYMENTS_DIR = Pattern.compile("\"com\\.redhat\\.deployments-dir\"[^\"]*\"([^\"]*)\",");
    private static final Pattern PATTERN_JBOSS_DEPLOYMENTS_DIR = Pattern.compile("\"org\\.jboss\\.deployments-dir\"[^\"]*\"([^\"]*)\",");
    private static final Pattern PATTERN_WOKRING_DIR = Pattern.compile("\"WorkingDir\"[^\"]*\"([^\"]*)\",");
    private static final String DEFAULT_DEPLOYMENT_DIR = "/opt/app-root/src";
    protected org.eclipse.core.resources.IProject deployProject;
    protected List<org.eclipse.core.resources.IProject> projects = new ArrayList<org.eclipse.core.resources.IProject>();
    private String sourcePath;
    protected String podPath;
    private IServerWorkingCopy server;
    private Map<String, DeploymentResourceMapper> deploymentMapperByProjectName;

    public ServerSettingsViewModel(IServerWorkingCopy server, Connection connection) {
        super(connection);
        this.server = server;
    }

    protected void update(Connection connection, List<Connection> connections, org.eclipse.core.resources.IProject deployProject, List<org.eclipse.core.resources.IProject> projects, String sourcePath, String podPath, Map<String, DeploymentResourceMapper> deploymentMapperByProjectName, IService service, List<ObservableTreeItem> serviceItems) {
        this.update(connection, connections, service, serviceItems);
        this.updateProjects(projects);
        if (this.deployProject != deployProject) {
            sourcePath = null;
        }
        deployProject = this.updateDeployProject(deployProject, projects);
        this.updateSourcePath(sourcePath, deployProject);
        this.updatePodPath(podPath, deploymentMapperByProjectName, service);
    }

    private void updateProjects(List<org.eclipse.core.resources.IProject> projects) {
        ArrayList<org.eclipse.core.resources.IProject> oldProjects = new ArrayList<org.eclipse.core.resources.IProject>(this.projects);
        ArrayList<org.eclipse.core.resources.IProject> newProjects = new ArrayList<org.eclipse.core.resources.IProject>();
        if (projects != null) {
            newProjects.addAll(projects);
        }
        this.projects.clear();
        this.projects.addAll(newProjects);
        this.firePropertyChange(PROPERTY_PROJECTS, oldProjects, this.projects);
    }

    protected org.eclipse.core.resources.IProject updateDeployProject(org.eclipse.core.resources.IProject deployProject, List<org.eclipse.core.resources.IProject> projects) {
        this.deployProject = this.getProjectOrDefault(deployProject, projects);
        this.firePropertyChange(PROPERTY_DEPLOYPROJECT, this.deployProject, this.deployProject);
        return this.deployProject;
    }

    protected void updateSourcePath(String sourcePath, org.eclipse.core.resources.IProject deployProject) {
        if (StringUtils.isEmpty((String)sourcePath) && ProjectUtils.isAccessible((org.eclipse.core.resources.IProject)deployProject)) {
            String projectPath = deployProject.getFullPath().toString();
            sourcePath = VariablesHelper.addWorkspacePrefix((String)projectPath);
        }
        this.sourcePath = sourcePath;
        this.firePropertyChange(PROPERTY_SOURCE_PATH, this.sourcePath, this.sourcePath);
    }

    protected void updatePodPath(String newPodPath, Map<String, DeploymentResourceMapper> deploymentResourceMapperByProjectName, IService service) {
        this.deploymentMapperByProjectName = deploymentResourceMapperByProjectName;
        this.podPath = newPodPath = this.getDeploymentDirectory(service, deploymentResourceMapperByProjectName);
        this.firePropertyChange(PROPERTY_POD_PATH, this.podPath, this.podPath);
    }

    private String getDeploymentDirectory(IService service, Map<String, DeploymentResourceMapper> deploymentResourceMapperByProjectName) {
        IResource imageStreamTag;
        String imageStreamTagJson;
        Collection<IResource> istags;
        Iterator<IResource> istagsIterator;
        IProject project;
        DeploymentResourceMapper deploymentMapper;
        String deploymentDirectory = null;
        if (service != null && deploymentResourceMapperByProjectName != null && (deploymentMapper = deploymentResourceMapperByProjectName.get((project = service.getProject()).getName())) != null && (istagsIterator = (istags = this.getImageStreamTags(service, deploymentMapper)).iterator()).hasNext() && (deploymentDirectory = this.matchFirstGroup(imageStreamTagJson = (imageStreamTag = istagsIterator.next()).toJson(true), PATTERN_REDHAT_DEPLOYMENTS_DIR)) == null && (deploymentDirectory = this.matchFirstGroup(imageStreamTagJson, PATTERN_JBOSS_DEPLOYMENTS_DIR)) == null) {
            deploymentDirectory = this.matchFirstGroup(imageStreamTagJson, PATTERN_WOKRING_DIR);
        }
        if (StringUtils.isEmpty(deploymentDirectory)) {
            deploymentDirectory = DEFAULT_DEPLOYMENT_DIR;
        }
        return deploymentDirectory;
    }

    private String matchFirstGroup(String imageStreamTag, Pattern pattern) {
        Matcher matcher = pattern.matcher(imageStreamTag);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private Collection<IResource> getImageStreamTags(IService service, DeploymentResourceMapper deploymentMapper) {
        Collection<IResource> pods = deploymentMapper.getResourcesFor((IResource)service, "Pod");
        Collection<IResource> deploymentConfigs = deploymentMapper.getResourcesFor(pods, "DeploymentConfig");
        Collection<IResource> builds = deploymentMapper.getResourcesFor(deploymentConfigs, "Build");
        Collection<IResource> buildConfigs = deploymentMapper.getResourcesFor(builds, "BuildConfig");
        Collection<IResource> istags = deploymentMapper.getResourcesFor(buildConfigs, "ImageStreamTag");
        return this.getVerboseResources(istags, this.getConnection());
    }

    public void setDeployProject(org.eclipse.core.resources.IProject project) {
        this.update(this.getConnection(), this.getConnections(), project, this.projects, this.sourcePath, this.podPath, this.deploymentMapperByProjectName, this.getService(), this.getServiceItems());
    }

    public org.eclipse.core.resources.IProject getDeployProject() {
        return this.deployProject;
    }

    protected void setProjects(List<org.eclipse.core.resources.IProject> projects) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, projects, this.sourcePath, this.podPath, this.deploymentMapperByProjectName, this.getService(), this.getServiceItems());
    }

    public List<org.eclipse.core.resources.IProject> getProjects() {
        return this.projects;
    }

    public void setSourcePath(String sourcePath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, sourcePath, this.podPath, this.deploymentMapperByProjectName, this.getService(), this.getServiceItems());
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setPodPath(String podPath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, podPath, this.deploymentMapperByProjectName, this.getService(), this.getServiceItems());
    }

    public String getPodPath() {
        return this.podPath;
    }

    @Override
    public void setService(IService service) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.deploymentMapperByProjectName, service, this.getServiceItems());
    }

    protected org.eclipse.core.resources.IProject getProjectOrDefault(org.eclipse.core.resources.IProject project, List<org.eclipse.core.resources.IProject> projects) {
        if (project == null) {
            project = (org.eclipse.core.resources.IProject)CollectionUtils.getFirstElement(projects);
        }
        return project;
    }

    @Override
    public void loadResources() {
        super.loadResources();
        this.setProjects(this.loadProjects());
        this.setImageStreamTags(this.loadImageStreamTags());
    }

    private void setImageStreamTags(Map<String, DeploymentResourceMapper> deploymentMapperByProjectName) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, deploymentMapperByProjectName, this.getService(), this.getServiceItems());
    }

    protected Map<String, DeploymentResourceMapper> getImageStreamTags() {
        return this.deploymentMapperByProjectName;
    }

    private Map<String, DeploymentResourceMapper> loadImageStreamTags() {
        List projects;
        HashMap<String, DeploymentResourceMapper> deploymentMapperByProjectName = new HashMap<String, DeploymentResourceMapper>();
        Connection connection = this.getConnection();
        if (connection != null && (projects = connection.getResources("Project")) != null) {
            projects.forEach(project -> {
                DeploymentResourceMapper deploymentMapper = new DeploymentResourceMapper(connection, new ProjectAdapterFake((IProject)project));
                deploymentMapper.refresh();
                deploymentMapperByProjectName.put(project.getName(), deploymentMapper);
            });
        }
        return deploymentMapperByProjectName;
    }

    private List<IResource> getVerboseResources(Collection<IResource> resources, Connection connection) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        return resources.stream().map(r -> connection.getResource(r)).collect(Collectors.toList());
    }

    protected List<org.eclipse.core.resources.IProject> loadProjects() {
        return ProjectUtils.getAllAccessibleProjects();
    }

    @Override
    protected List<ObservableTreeItem> loadServices(Connection connection) {
        ObservableTreeItem connectionItem = ServiceTreeItemsFactory.INSTANCE.create(connection);
        connectionItem.load();
        return connectionItem.getChildren();
    }

    public void updateServer() {
        this.updateServer(this.server);
    }

    private void updateServer(IServerWorkingCopy server) throws OpenShiftException {
        String connectionUrl = this.getConnectionUrl(this.getConnection());
        String baseServerName = OpenShiftServerUtils.getServerName((IService)this.getService(), (Connection)this.getConnection());
        String serverName = ServerUtils.getServerName((String)baseServerName);
        OpenShiftServerUtils.updateServer((String)serverName, (String)connectionUrl, (IService)this.getService(), (String)this.sourcePath, (String)this.podPath, (org.eclipse.core.resources.IProject)this.deployProject, (IServerWorkingCopy)server);
        OpenShiftServerUtils.updateServerProject((String)connectionUrl, (IService)this.getService(), (String)this.sourcePath, (String)this.podPath, (org.eclipse.core.resources.IProject)this.deployProject);
    }

    private String getConnectionUrl(Connection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection((IConnection)connection);
            return connectionUrl.toString();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, "Could not get url for connection {0}", new Object[]{connection.getHost()});
        }
    }

    protected IServerWorkingCopy getServer() {
        return this.server;
    }

    public static class ProjectAdapterFake
    implements IProjectAdapter {
        private IProject project;

        private ProjectAdapterFake(IProject project) {
            this.project = project;
        }

        @Override
        public Collection<IResourceUIModel> getBuilds() {
            return null;
        }

        @Override
        public void setBuilds(Collection<IResourceUIModel> builds) {
        }

        @Override
        public void setBuildResources(Collection<IBuild> builds) {
        }

        @Override
        public Collection<IResourceUIModel> getImageStreams() {
            return null;
        }

        @Override
        public void setImageStreams(Collection<IResourceUIModel> models) {
        }

        @Override
        public void setImageStreamResources(Collection<IResource> streams) {
        }

        @Override
        public Collection<IResourceUIModel> getDeploymentConfigs() {
            return null;
        }

        @Override
        public void setDeploymentConfigs(Collection<IResourceUIModel> models) {
        }

        @Override
        public void setDeploymentConfigResources(Collection<IResource> dcs) {
        }

        @Override
        public Collection<IResourceUIModel> getPods() {
            return null;
        }

        @Override
        public void setPods(Collection<IResourceUIModel> pods) {
        }

        @Override
        public void setPodResources(Collection<IPod> pods) {
        }

        @Override
        public Collection<IResourceUIModel> getRoutes() {
            return null;
        }

        @Override
        public void setRoutes(Collection<IResourceUIModel> routes) {
        }

        @Override
        public void setRouteResources(Collection<IResource> routes) {
        }

        @Override
        public Collection<IResourceUIModel> getReplicationControllers() {
            return null;
        }

        @Override
        public void setReplicationControllers(Collection<IResourceUIModel> rcs) {
        }

        @Override
        public void setReplicationControllerResources(Collection<IResource> rcs) {
        }

        @Override
        public Collection<IResourceUIModel> getBuildConfigs() {
            return null;
        }

        @Override
        public void setBuildConfigs(Collection<IResourceUIModel> buildConfigs) {
        }

        @Override
        public void setBuildConfigResources(Collection<IResource> buildConfigs) {
        }

        @Override
        public Collection<IResourceUIModel> getServices() {
            return null;
        }

        @Override
        public void setServices(Collection<IResourceUIModel> services) {
        }

        @Override
        public void setServiceResources(Collection<IResource> services) {
        }

        @Override
        public void add(IResource resource) {
        }

        @Override
        public void update(IResource resource) {
        }

        @Override
        public void remove(IResource resource) {
        }

        @Override
        public Object getParent() {
            return null;
        }

        public void refresh() {
        }

        @Override
        public IProject getProject() {
            return this.project;
        }

        @Override
        public <T extends IResource> void setResources(Collection<T> resources, String kind) {
        }

        @Override
        public Collection<Deployment> getDeployments() {
            return null;
        }

        @Override
        public void setDeployments(Collection<Deployment> deployment) {
        }
    }

    static class ServiceTreeItemsFactory
    implements IModelFactory {
        private static final ServiceTreeItemsFactory INSTANCE = new ServiceTreeItemsFactory();

        ServiceTreeItemsFactory() {
        }

        @Override
        public <T> List<T> createChildren(Object parent) {
            if (parent instanceof Connection) {
                return ((Connection)parent).getResources("Project");
            }
            if (parent instanceof IProject) {
                return ((IProject)parent).getResources("Service");
            }
            return Collections.emptyList();
        }

        public List<ObservableTreeItem> create(Collection<?> openShiftObjects) {
            if (openShiftObjects == null) {
                return Collections.emptyList();
            }
            ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
            for (Object openShiftObject : openShiftObjects) {
                ObservableTreeItem item = this.create(openShiftObject);
                if (item == null) continue;
                items.add(item);
            }
            return items;
        }

        public ObservableTreeItem create(Object object) {
            return new ObservableTreeItem(object, this);
        }
    }
}

