/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IService;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsViewModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceDetailViews;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewerFilter;
import org.jboss.tools.openshift.internal.ui.server.ServicesViewLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;

public class SelectServiceWizard
extends AbstractOpenShiftWizard<ServiceViewModel> {
    private String description;

    public SelectServiceWizard(String description, IService service, Connection connection) {
        super("Select Service", (Object)new ServiceViewModel(service, connection));
        this.description = description;
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectServiceWizardPage());
    }

    public IService getService() {
        return ((ServiceViewModel)((Object)this.getModel())).getService();
    }

    public class SelectServiceWizardPage
    extends AbstractOpenShiftWizardPage {
        public SelectServiceWizardPage() {
            super(SelectServiceWizard.this.getWindowTitle(), SelectServiceWizard.this.description, "", (IWizard)SelectServiceWizard.this);
        }

        protected void doCreateControls(Composite parent, DataBindingContext dbc) {
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
            Composite container = new Composite(parent, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().applyTo(container);
            Composite serviceComposite = this.createServiceControls(container, dbc);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)serviceComposite);
            this.loadResources();
        }

        private Composite createServiceControls(Composite container, DataBindingContext dbc) {
            Group servicesGroup = new Group(container, 0);
            servicesGroup.setText("Services");
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)servicesGroup);
            Label selectorLabel = new Label((Composite)servicesGroup, 0);
            selectorLabel.setText("Selector:");
            Text selectorText = UIUtils.createSearchText((Composite)servicesGroup);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)selectorText);
            TreeViewer servicesViewer = this.createServicesTreeViewer((Composite)servicesGroup, selectorText);
            BeanProperties.list((String)"serviceItems").observe(SelectServiceWizard.this.getModel()).addListChangeListener(this.onServiceItemsChanged(servicesViewer));
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).hint(-1, 160).grab(true, true).applyTo(servicesViewer.getControl());
            selectorText.addModifyListener(this.onFilterTextModified(servicesViewer));
            IViewerObservableValue selectedServiceTreeItem = ViewerProperties.singleSelection().observe((Viewer)servicesViewer);
            ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedServiceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter(IService.class))).validatingAfterConvert(new IValidator(){

                public IStatus validate(Object value) {
                    if (!(value instanceof IService)) {
                        return ValidationStatus.cancel((String)"Please select a service that your adapter will publish to.");
                    }
                    return ValidationStatus.ok();
                }
            })).to(BeanProperties.value((String)"service").observe(SelectServiceWizard.this.getModel())).converting((IConverter)new Model2ObservableTreeItemConverter(new ServerSettingsViewModel.ServiceTreeItemsFactory()))).in(dbc);
            Label detailsLabel = new Label((Composite)servicesGroup, 0);
            detailsLabel.setText("Service Details:");
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).applyTo((Control)detailsLabel);
            Composite detailsContainer = new Composite((Composite)servicesGroup, 0);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).hint(-1, 150).applyTo((Control)detailsContainer);
            WritableValue selectedService = new WritableValue();
            ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedServiceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter())).to((IObservableValue)selectedService).notUpdatingParticipant()).in(dbc);
            new ServiceDetailViews((IObservableValue)selectedService, detailsContainer, dbc).createControls();
            return servicesGroup;
        }

        private IListChangeListener onServiceItemsChanged(final TreeViewer servicesViewer) {
            return new IListChangeListener(){

                public void handleListChange(ListChangeEvent event) {
                    servicesViewer.expandAll();
                }
            };
        }

        private TreeViewer createServicesTreeViewer(Composite parent, Text selectorText) {
            TreeViewer applicationTemplatesViewer = new TreeViewer(parent, 2820);
            MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"serviceItems"), BeanProperties.list((String)"children")});
            ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
            applicationTemplatesViewer.setContentProvider((IContentProvider)contentProvider);
            applicationTemplatesViewer.setLabelProvider((IBaseLabelProvider)new ServicesViewLabelProvider());
            applicationTemplatesViewer.addFilter((ViewerFilter)new ServiceViewerFilter(selectorText));
            applicationTemplatesViewer.setAutoExpandLevel(-1);
            applicationTemplatesViewer.setInput(SelectServiceWizard.this.getModel());
            return applicationTemplatesViewer;
        }

        protected ModifyListener onFilterTextModified(final TreeViewer applicationTemplatesViewer) {
            return new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    applicationTemplatesViewer.refresh();
                    applicationTemplatesViewer.expandAll();
                }
            };
        }

        private void loadResources() {
            try {
                WizardUtils.runInWizard((Job)new Job("Loading services..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        ((ServiceViewModel)((Object)SelectServiceWizard.this.getModel())).loadResources();
                        return Status.OK_STATUS;
                    }
                }, (IWizardContainer)this.getWizard().getContainer());
            }
            catch (InterruptedException | InvocationTargetException exception) {}
        }
    }
}

