/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.models.DeploymentResourceMapper;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsViewModel;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class OpenShiftServerEditorModel
extends ServerSettingsViewModel {
    public static final String PROPERTY_CONNECTIONS = "connections";
    public static final String PROPERTY_OVERRIDE_PROJECT = "overrideProject";
    private boolean overrideProject = false;

    public OpenShiftServerEditorModel(IServerWorkingCopy server, Connection connection) {
        super(server, connection);
    }

    private void update(boolean overrideProject, Connection connection, List<Connection> connections, IProject deployProject, List<IProject> projects, String sourcePath, String podPath, Map<String, DeploymentResourceMapper> deploymentMapperByProjectName, IService service, List<ObservableTreeItem> serviceItems) {
        this.update(connection, connections, deployProject, projects, sourcePath, podPath, deploymentMapperByProjectName, service, serviceItems);
        this.overrideProject = overrideProject;
        this.firePropertyChange(PROPERTY_OVERRIDE_PROJECT, this.overrideProject, this.overrideProject);
    }

    public boolean isOverrideProject() {
        return this.overrideProject;
    }

    public void setOverrideProject(boolean overrideProject) {
        this.update(overrideProject, this.getConnection(), this.getConnections(), this.getDeployProject(), this.getProjects(), this.getSourcePath(), this.getPodPath(), this.getImageStreamTags(), this.getService(), this.getServiceItems());
    }

    @Override
    protected IProject getProjectOrDefault(IProject project, List<IProject> projects) {
        return project;
    }

    @Override
    protected IService getServiceOrDefault(IService service, List<ObservableTreeItem> services) {
        return service;
    }

    @Override
    protected List<ObservableTreeItem> loadServices(Connection connection) {
        return Collections.emptyList();
    }
}

