/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property.tabbed;

import com.openshift.restclient.model.IResource;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.openshift.core.OpenShiftAPIAnnotations;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;

public class OpenShiftResourcePropertySection
extends AbstractPropertySection
implements OpenShiftAPIAnnotations {
    private TableViewer table;
    private PropertySheetPage details;
    private TabbedPropertySheetPage page;
    private ISelectionProvider selectionProvider;
    private String menuContributionId;

    public OpenShiftResourcePropertySection() {
    }

    public OpenShiftResourcePropertySection(String menuContributionId) {
        this.menuContributionId = menuContributionId;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.createContents(parent, aTabbedPropertySheetPage);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.page != null) {
            this.page.getSite().setSelectionProvider(this.selectionProvider);
        }
    }

    protected void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.page = aTabbedPropertySheetPage;
        SashForm container = new SashForm(parent, 512);
        Composite tableContainer = new Composite((Composite)container, 0);
        tableContainer.setLayout((Layout)new FillLayout());
        this.table = this.createTable(tableContainer);
        this.details = new PropertySheetPage();
        this.details.createControl((Composite)container);
        this.selectionProvider = new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                OpenShiftResourcePropertySection.this.table.removeSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return OpenShiftResourcePropertySection.this.table.getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                OpenShiftResourcePropertySection.this.table.addSelectionChangedListener(listener);
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ObservableListContentProvider()).sorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IResource r1 = ((IResourceUIModel)e1).getResource();
                IResource r2 = ((IResourceUIModel)e2).getResource();
                return r1.getName().compareTo(r2.getName());
            }
        }).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return model.getResource().getName();
            }
        }).name("Name").align(16384).weight(1).minWidth(10).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return model.getResource().getCreationTimeStamp();
            }
        }).name("Created").align(16384).weight(1).minWidth(5).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)model.getResource().getLabels());
            }
        }).name("Labels").align(16384).weight(1).minWidth(25).buildColumn().buildViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenShiftResourcePropertySection.this.details.selectionChanged(null, event.getSelection());
            }
        });
        this.addContextMenu(viewer);
        return viewer;
    }

    protected void addContextMenu(TableViewer viewer) {
        if (this.menuContributionId != null) {
            IMenuManager contextMenu = UIUtils.createContextMenu((Control)viewer.getTable());
            UIUtils.registerContributionManager((String)this.menuContributionId, (IContributionManager)contextMenu, (Control)viewer.getTable());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object model = UIUtils.getFirstElement((ISelection)selection);
        if (model == null) {
            return;
        }
        ITabDescriptor tab = this.page.getSelectedTab();
        if (tab == null) {
            return;
        }
        String id = tab.getId();
        String property = StringUtils.right((String)id, (int)(id.length() - id.lastIndexOf(".") - 1));
        this.table.setInput((Object)BeanProperties.list((String)property).observe(model));
    }

    public void dispose() {
        if (this.table != null && this.table.getTable() != null) {
            this.table.getTable().dispose();
        }
        if (this.details != null) {
            this.details.dispose();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        if (!DisposeUtils.isDisposed((Viewer)this.table)) {
            this.table.refresh();
        }
        if (!DisposeUtils.isDisposed((Control)this.details.getControl())) {
            this.details.refresh();
        }
    }
}

