/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property.tabbed;

import com.openshift.restclient.model.IBuild;
import java.text.ParseException;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.openshift.core.OpenShiftAPIAnnotations;
import org.jboss.tools.openshift.internal.common.ui.utils.DateTimeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;

public class BuildsPropertySection
extends AbstractPropertySection
implements OpenShiftAPIAnnotations {
    private static final String CONTEXT_MENU_ID = "popup:org.jboss.tools.openshift.ui.properties.tab.BuildsTab";
    private TabbedPropertySheetPage page;
    private ISelectionProvider selectionProvider;
    private TableViewer table;
    private PropertySheetPage buildDetails;

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.page != null) {
            this.page.getSite().setSelectionProvider(this.selectionProvider);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        SashForm container = new SashForm(parent, 512);
        Composite tableContainer = new Composite((Composite)container, 0);
        tableContainer.setLayout((Layout)new FillLayout());
        this.table = this.createTable(tableContainer);
        this.buildDetails = new PropertySheetPage();
        this.buildDetails.createControl((Composite)container);
        this.selectionProvider = new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                BuildsPropertySection.this.table.removeSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return BuildsPropertySection.this.table.getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                BuildsPropertySection.this.table.addSelectionChangedListener(listener);
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ObservableListContentProvider()).sorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBuild build1 = (IBuild)((IResourceUIModel)e1).getResource();
                IBuild build2 = (IBuild)((IResourceUIModel)e2).getResource();
                try {
                    return -1 * DateTimeUtils.parse((String)build1.getCreationTimeStamp()).compareTo(DateTimeUtils.parse((String)build2.getCreationTimeStamp()));
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        }).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return ((IBuild)model.getResource()).getName();
            }
        }).name("Name").align(16384).weight(1).minWidth(10).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return ((IBuild)model.getResource()).getAnnotation("openshift.io/build.number");
            }
        }).name("Build").align(16384).weight(1).minWidth(5).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return ((IBuild)model.getResource()).getStatus();
            }
        }).name("Status").align(16384).weight(1).minWidth(25).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceUIModel>(){

            public String getValue(IResourceUIModel model) {
                return DateTimeUtils.formatSince((String)model.getResource().getCreationTimeStamp());
            }
        }).name("Started").align(16384).weight(1).buildColumn().buildViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildsPropertySection.this.buildDetails.selectionChanged(null, event.getSelection());
            }
        });
        this.addContextMenu(table);
        return viewer;
    }

    private void addContextMenu(Table table) {
        IMenuManager contextMenu = UIUtils.createContextMenu((Control)table);
        UIUtils.registerContributionManager((String)CONTEXT_MENU_ID, (IContributionManager)contextMenu, (Control)table);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object model = UIUtils.getFirstElement((ISelection)selection);
        if (model == null) {
            return;
        }
        this.table.setInput((Object)BeanProperties.list((String)"builds").observe(model));
    }

    public void dispose() {
        if (this.table != null && this.table.getTable() != null) {
            this.table.getTable().dispose();
        }
        if (this.buildDetails != null) {
            this.buildDetails.dispose();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        this.table.refresh();
        this.buildDetails.refresh();
    }
}

