/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ExtTextPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.PrefixPropertySourceKey;

public class ResourcePropertySource<T extends IResource>
implements IPropertySource {
    private static final String ANNOTATIONS = "Annotations";
    private static final String CATEGORY = "Basic";
    private static final String LABELS = "Labels";
    private T resource;

    public ResourcePropertySource(T resource) {
        this.resource = resource;
    }

    protected T getResource() {
        return this.resource;
    }

    protected IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Object[] common = new IPropertyDescriptor[]{new ExtTextPropertyDescriptor(Ids.Name, CATEGORY), new ExtTextPropertyDescriptor((Object)Ids.Created, "Creation Timestamp", CATEGORY), new ExtTextPropertyDescriptor(Ids.Namespace, CATEGORY)};
        List<IPropertyDescriptor> annotations = this.buildPropertyDescriptors(ANNOTATIONS, this.resource.getAnnotations());
        common = (IPropertyDescriptor[])ArrayUtils.addAll((Object[])common, (Object[])annotations.toArray());
        List<IPropertyDescriptor> labels = this.buildPropertyDescriptors(LABELS, this.resource.getLabels());
        common = (IPropertyDescriptor[])ArrayUtils.addAll((Object[])common, (Object[])labels.toArray());
        return (IPropertyDescriptor[])ArrayUtils.addAll((Object[])common, (Object[])this.getResourcePropertyDescriptors());
    }

    private List<IPropertyDescriptor> buildPropertyDescriptors(String prefix, Map<String, String> values) {
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            descriptors.add((IPropertyDescriptor)new ExtTextPropertyDescriptor(new PrefixPropertySourceKey(prefix, entry.getKey()), entry.getKey(), prefix));
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Ids) {
            Ids e = (Ids)((Object)id);
            switch (e) {
                case Name: {
                    return this.resource.getName();
                }
                case Namespace: {
                    return this.resource.getNamespace();
                }
                case Created: {
                    return this.resource.getCreationTimeStamp();
                }
            }
        }
        if (id instanceof PrefixPropertySourceKey) {
            PrefixPropertySourceKey key = (PrefixPropertySourceKey)id;
            String prefix = key.getPrefix();
            if (ANNOTATIONS.equals(prefix)) {
                return this.resource.getAnnotation(key.getKey());
            }
            if (LABELS.equals(prefix)) {
                return this.resource.getLabels().get(key.getKey());
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public static enum Ids {
        Created,
        Name,
        Namespace;

    }
}

