/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.jboss.tools.common.jobs.ChainedJob;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;
import org.jboss.tools.openshift.internal.ui.property.OpenShiftResourceInput;

public class OpenShiftResourceDocumentProvider
extends AbstractDocumentProvider {
    private WorkspaceOperationRunner operationRunner;

    protected IDocument createDocument(Object element) throws CoreException {
        OpenShiftResourceInput input = this.getInput(element);
        Document document = null;
        if (input != null) {
            IResource resource = input.getResource();
            document = new Document(resource.toJson());
        }
        return document;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, final Object element, IDocument document, boolean overwrite) throws CoreException {
        final OpenShiftResourceInput input = this.getInput(element);
        if (input == null) {
            return;
        }
        final IResource resource = input.getResource();
        final IClient client = (IClient)resource.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, IClient>(){

            public IClient visit(IClientCapability cap) {
                return cap.getClient();
            }
        }, null);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        Connection connection = input.getConnection();
        final String resourceName = input.getName();
        final IResource newResource = connection.getResourceFactory().create(document.get());
        final Exception[] exceptions = new Exception[1];
        ChainedJob updateResourceJob = new ChainedJob("Update " + resourceName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    client.update(newResource);
                }
                catch (Exception e) {
                    OpenShiftException oe;
                    exceptions[0] = e;
                    Display.getDefault().asyncExec(() -> OpenShiftResourceDocumentProvider.this.setDirty(element));
                    String problem = e.getMessage();
                    if (e instanceof OpenShiftException && (oe = (OpenShiftException)e).getStatus() != null) {
                        problem = oe.getStatus().getMessage();
                    }
                    String projectName = resource.getProject() == null ? "unknown" : resource.getProject().getName();
                    IStatus error = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not update \"{0}\" for project \"{1}\" : {2}", (Object[])new String[]{resourceName, projectName, problem}), (Throwable)e);
                    return error;
                }
                return Status.OK_STATUS;
            }
        };
        final RefreshResourcesJob refreshResourceJob = new RefreshResourcesJob(() -> Collections.singleton(newResource), false);
        final OpenShiftResourceDocumentProvider docProvider = this;
        refreshResourceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Collection<IResource> refreshed = refreshResourceJob.getRefreshedResources();
                if (!refreshed.isEmpty()) {
                    Display.getDefault().asyncExec(() -> {
                        IResource updatedResource = (IResource)refreshed.iterator().next();
                        input.setResource(updatedResource);
                        try {
                            docProvider.resetDocument(input);
                        }
                        catch (Exception e) {
                            exceptionArray[0] = e;
                            OpenShiftResourceDocumentProvider.this.setDirty(element);
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
        });
        updateResourceJob.setNextJob((Job)refreshResourceJob);
        updateResourceJob.schedule();
        Shell shell = Display.getCurrent().getActiveShell();
        service.showInDialog(shell, (Job)updateResourceJob);
        if (exceptions[0] != null) {
            throw new CoreException(OpenShiftUIActivator.statusFactory().errorStatus((Throwable)exceptions[0]));
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.operationRunner == null) {
            this.operationRunner = new WorkspaceOperationRunner();
        }
        this.operationRunner.setProgressMonitor(monitor);
        return this.operationRunner;
    }

    private OpenShiftResourceInput getInput(Object o) {
        return o instanceof OpenShiftResourceInput ? (OpenShiftResourceInput)o : null;
    }

    public boolean isReadOnly(Object element) {
        return this.getInput(element) == null;
    }

    public boolean isModifiable(Object element) {
        return this.getInput(element) != null;
    }

    private void setDirty(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo != null) {
            elementInfo.fCanBeSaved = true;
            this.fireElementDirtyStateChanged(element, true);
        }
    }
}

