/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.models.Deployment;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.property.BuildConfigPropertySource;
import org.jboss.tools.openshift.internal.ui.property.BuildPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ConnectionPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ImageStreamPropertySource;
import org.jboss.tools.openshift.internal.ui.property.PodPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ReplicationControllerPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.RoutePropertySource;
import org.jboss.tools.openshift.internal.ui.property.ServicePropertySource;

public class OpenShiftPropertySourceAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        block27: {
            if (adapterType != IPropertySource.class) break block27;
            if (adaptableObject instanceof Connection) {
                return new ConnectionPropertySource((IConnection)((Connection)adaptableObject));
            }
            if (adaptableObject instanceof Deployment) {
                return new ServicePropertySource(((Deployment)adaptableObject).getService());
            }
            if (!(adaptableObject instanceof IResource) && !(adaptableObject instanceof IResourceUIModel)) break block27;
            IResource resource = adaptableObject instanceof IResourceUIModel ? ((IResourceUIModel)adaptableObject).getResource() : (IResource)adaptableObject;
            switch (resource.getKind()) {
                case "Build": {
                    return new BuildPropertySource((IBuild)resource);
                }
                case "BuildConfig": {
                    return new BuildConfigPropertySource((IBuildConfig)resource);
                }
                case "ImageStream": {
                    return new ImageStreamPropertySource((IImageStream)resource);
                }
                case "Pod": {
                    return new PodPropertySource((IPod)resource);
                }
                case "ReplicationController": {
                    return new ReplicationControllerPropertySource((IReplicationController)resource);
                }
                case "Route": {
                    return new RoutePropertySource((IRoute)resource);
                }
                case "Service": {
                    return new ServicePropertySource((IService)resource);
                }
            }
            return new ResourcePropertySource<IResource>(resource);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IPropertySource.class};
    }
}

