/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.build.IBuildSource;
import com.openshift.restclient.model.build.IBuildStatus;
import com.openshift.restclient.model.build.IBuildStrategy;
import com.openshift.restclient.model.build.IDockerBuildStrategy;
import com.openshift.restclient.model.build.IGitBuildSource;
import com.openshift.restclient.model.build.ISourceBuildStrategy;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jboss.tools.openshift.internal.common.ui.utils.DateTimeUtils;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;

public class BuildPropertySource
extends ResourcePropertySource<IBuild> {
    public BuildPropertySource(IBuild resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"status", "Status"), new TextPropertyDescriptor((Object)"started", "Started"), new TextPropertyDescriptor((Object)"duration", "Duration"), new TextPropertyDescriptor((Object)"build.config", "Build Configuration"), new TextPropertyDescriptor((Object)"build.strategy", "Build Strategy"), new TextPropertyDescriptor((Object)"builder.image", "Builder Image"), new TextPropertyDescriptor((Object)"source.type", "Source Type"), new TextPropertyDescriptor((Object)"source.repo", "Source Repo"), new TextPropertyDescriptor((Object)"source.ref", "Source Ref."), new TextPropertyDescriptor((Object)"source.contextDir", "Source Context Dir."), new TextPropertyDescriptor((Object)"output.image", "Output Image"), new TextPropertyDescriptor((Object)"push.secret", "Push Secret")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        IBuild build = (IBuild)this.getResource();
        switch ((String)id) {
            case "status": {
                return build.getStatus();
            }
            case "started": {
                return DateTimeUtils.formatSince((String)build.getCreationTimeStamp());
            }
            case "build.config": {
                return build.getLabels().get("openshift.io/build-config.name");
            }
            case "builder.image": 
            case "build.strategy": {
                return this.handleBuildStrategy((String)id, build.getBuildStrategy());
            }
            case "source.ref": 
            case "source.contextDir": 
            case "source.repo": 
            case "source.type": {
                return this.handleBuildSource((String)id, build.getBuildSource());
            }
            case "duration": 
            case "output.image": {
                return this.handleBuildStatus((String)id, build.getBuildStatus());
            }
            case "push.secret": {
                return build.getPushSecret();
            }
        }
        return super.getPropertyValue(id);
    }

    private Object handleBuildStatus(String id, IBuildStatus status) {
        block10: {
            if (status == null) break block10;
            switch (id) {
                case "output.image": {
                    return status.getOutputDockerImage() != null ? status.getOutputDockerImage().getUriWithoutHost() : "";
                }
                case "duration": {
                    return DateTimeUtils.formatDuration((long)status.getDuration());
                }
            }
        }
        return "";
    }

    private Object handleBuildStrategy(String id, IBuildStrategy strategy) {
        if (strategy == null) {
            return "";
        }
        switch (id) {
            case "build.strategy": {
                return strategy.getType();
            }
            case "builder.image": {
                if (strategy instanceof IDockerBuildStrategy) {
                    return ((IDockerBuildStrategy)strategy).getBaseImage();
                }
                if (!(strategy instanceof ISourceBuildStrategy)) break;
                return ((ISourceBuildStrategy)strategy).getImage();
            }
        }
        return "";
    }

    private Object handleBuildSource(String id, IBuildSource buildSource) {
        block15: {
            if (buildSource == null) {
                return "";
            }
            if ("source.type".equals(id)) {
                return buildSource.getType();
            }
            if (!(buildSource instanceof IGitBuildSource)) break block15;
            IGitBuildSource source = (IGitBuildSource)buildSource;
            switch (id) {
                case "source.repo": {
                    return source.getURI();
                }
                case "source.ref": {
                    return source.getRef();
                }
                case "source.contextDir": {
                    return source.getContextDir();
                }
            }
        }
        return "";
    }
}

