/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.openshift.internal.ui.preferences.SSLCertificatesPreference;
import org.jboss.tools.openshift.internal.ui.wizard.connection.SSLCertificateUIHelper;

public class SSLCertificatesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    List<SSLCertificatesPreference.Item> items = new ArrayList<SSLCertificatesPreference.Item>();
    CheckboxTableViewer listViewer;
    Button remove;
    StyledText details;
    SSLCertificateUIHelper uiHelper = new SSLCertificateUIHelper();

    public SSLCertificatesPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SSLCertificatesPreference.getInstance().getPreferenceStore());
        this.items.addAll(SSLCertificatesPreference.getInstance().getSavedItems());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.adjustGridLayout();
        Label label = new Label(composite, 0);
        GridData dl = new GridData();
        dl.horizontalSpan = 3;
        label.setLayoutData((Object)dl);
        label.setText("Decisions on untrusted SSL certificates, checked ones are accepted.");
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LP());
        this.listViewer.setContentProvider((IContentProvider)new CP());
        this.listViewer.getTable().setLinesVisible(true);
        this.listViewer.getTable().setHeaderVisible(true);
        String[] columnNames = new String[]{"Approved", "Certificate", "Validity"};
        int[] columnWidths = new int[]{80, 200, 100};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = new TableColumn(this.listViewer.getTable(), 16384);
            tc.setText(columnNames[i]);
            tc.setWidth(columnWidths[i]);
            tc.setResizable(i > 0);
            ++i;
        }
        this.listViewer.setInput(this.items);
        this.updateChecked();
        this.remove = new Button(composite, 8);
        this.remove.setText("Delete");
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSLCertificatesPreferencePage.this.deleteSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData d = new GridData();
        d.verticalAlignment = 1;
        this.remove.setLayoutData((Object)d);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SSLCertificatesPreferencePage.this.updateRemoveButton();
                SSLCertificatesPreferencePage.this.updateDetails();
            }
        });
        this.updateRemoveButton();
        Label detailsLabel = new Label(composite, 0);
        GridData d1 = new GridData(768);
        d1.horizontalIndent = 15;
        d1.horizontalSpan = 3;
        detailsLabel.setLayoutData((Object)d1);
        detailsLabel.setText("Certificate details:");
        this.details = new StyledText(composite, 2624);
        this.details.setEditable(false);
        GridData d2 = new GridData(768);
        d2.horizontalSpan = 2;
        d2.heightHint = 250;
        this.details.setLayoutData((Object)d2);
        this.updateDetails();
    }

    private void updateRemoveButton() {
        if (this.isActive()) {
            this.remove.setEnabled(!this.listViewer.getSelection().isEmpty());
        }
    }

    private void updateDetails() {
        if (this.isActive()) {
            if (this.listViewer.getSelection().isEmpty()) {
                this.uiHelper.clean(this.details);
            } else {
                IStructuredSelection s = this.listViewer.getStructuredSelection();
                SSLCertificatesPreference.Item item = (SSLCertificatesPreference.Item)s.getFirstElement();
                this.uiHelper.writeCertificate(item.getIssuer(), item.getValidity(), item.getFingerprint(), this.details);
            }
        }
    }

    protected void adjustGridLayout() {
        this.getFieldEditorParent().setLayoutData((Object)new GridData(768));
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 3;
    }

    void deleteSelection() {
        IStructuredSelection s = this.listViewer.getStructuredSelection();
        if (!s.isEmpty()) {
            SSLCertificatesPreference.Item item = (SSLCertificatesPreference.Item)s.getFirstElement();
            this.items.remove(item);
            this.listViewer.setInput(this.items);
        }
    }

    public boolean performOk() {
        for (SSLCertificatesPreference.Item i : this.items) {
            i.checked = this.listViewer.getChecked((Object)i);
        }
        SSLCertificatesPreference.getInstance().saveWorkingCopy(this.items);
        return true;
    }

    protected void performDefaults() {
        if (this.listViewer == null || this.listViewer.getTable() == null || this.listViewer.getTable().isDisposed()) {
            return;
        }
        this.items.clear();
        this.items.addAll(SSLCertificatesPreference.getInstance().getSavedItems());
        this.listViewer.setInput(this.items);
        this.updateChecked();
    }

    private void updateChecked() {
        if (this.isActive()) {
            for (SSLCertificatesPreference.Item i : this.items) {
                this.listViewer.setChecked((Object)i, i.checked);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.listViewer != null) {
            this.listViewer = null;
        }
        if (this.remove != null) {
            this.remove = null;
        }
    }

    boolean isActive() {
        return this.listViewer != null && this.listViewer.getTable() != null && !this.listViewer.getTable().isDisposed();
    }

    class CP
    implements IStructuredContentProvider {
        CP() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return SSLCertificatesPreferencePage.this.items.toArray();
        }
    }

    class LP
    extends LabelProvider
    implements ITableLabelProvider {
        LP() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SSLCertificatesPreference.Item i = (SSLCertificatesPreference.Item)element;
            if (columnIndex == 0) {
                return "";
            }
            if (columnIndex == 2) {
                return i.getValidity().replace("\n", " ").replace("\r", " ");
            }
            return i.getIssuer().replace("\n", " ").replace("\r", " ");
        }
    }
}

