/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.X509CertificateParser;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class SSLCertificatesPreference {
    static final String ALLOWED_CERTIFICATES = "allowed_certificates";
    static final String SEPARATOR = ";";
    static final String NL = StringUtils.getLineSeparator();
    static final SSLCertificatesPreference instance = new SSLCertificatesPreference();
    private List<Item> savedItems = null;

    public static SSLCertificatesPreference getInstance() {
        return instance;
    }

    private SSLCertificatesPreference() {
    }

    protected IPreferenceStore getPreferenceStore() {
        return OpenShiftUIActivator.getDefault().getCorePreferenceStore();
    }

    public Boolean getAllowedByCertificate(X509Certificate certificate) {
        X509CertificateParser p = new X509CertificateParser(certificate);
        Item i = new Item(false, p.getIssuer(), p.getValidity(), p.getFingerprint());
        Item item = this.findItem(this.getSavedItems(), i);
        return item != null ? Boolean.valueOf(item.checked) : null;
    }

    public void setAllowedByCertificate(X509Certificate certificate, boolean result) {
        X509CertificateParser p = new X509CertificateParser(certificate);
        Item i = new Item(result, p.getIssuer(), p.getValidity(), p.getFingerprint());
        List<Item> savedItems = this.getSavedItems();
        Item item = this.findItem(savedItems, i);
        if (item == null) {
            savedItems.add(i);
        } else {
            item.checked = result;
        }
        this.saveItemsToPreference(savedItems);
    }

    List<Item> getSavedItems() {
        if (this.savedItems == null) {
            ArrayList<Item> savedItems = new ArrayList<Item>();
            String value = this.getPreferenceStore().getString(ALLOWED_CERTIFICATES);
            if (value != null && value.length() > 0) {
                String[] tokens = value.split(SEPARATOR);
                int i = 0;
                while (i + 4 <= tokens.length) {
                    boolean checked = "true".equals(tokens[i++]);
                    String issuedBy = tokens[i++];
                    String validity = tokens[i++];
                    String fingerprint = tokens[i++];
                    if (!this.isValid(validity)) continue;
                    savedItems.add(new Item(checked, issuedBy, validity, fingerprint));
                }
            }
            this.savedItems = savedItems;
        }
        return this.savedItems;
    }

    private boolean isValid(String validity) {
        int expiresOnIndex = validity.indexOf("Expires On: ");
        if (expiresOnIndex >= 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss");
            String expiresOn = validity.substring(expiresOnIndex + "Expires On: ".length()).trim();
            try {
                Date date = dateFormat.parse(expiresOn);
                return date.getTime() > System.currentTimeMillis();
            }
            catch (ParseException parseException) {
                OpenShiftUIActivator.getDefault().getLogger().logError("SSLCertificatesPreference.isValid(String): Could not parse '" + expiresOn + "' in format " + "E, d MMM yyyy HH:mm:ss");
            }
        }
        return true;
    }

    private Item findItem(List<Item> items, Item item) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        return items.stream().filter(i -> i.equals(item)).findFirst().orElse(null);
    }

    void saveWorkingCopy(List<Item> items) {
        List<Item> savedItems = this.getSavedItems();
        savedItems.clear();
        savedItems.addAll(items);
        this.saveItemsToPreference(savedItems);
    }

    private void saveItemsToPreference(List<Item> items) {
        StringBuilder sb = new StringBuilder();
        items.stream().forEach(i -> {
            StringBuilder stringBuilder2 = sb.append(i.toPreferenceValue());
        });
        this.getPreferenceStore().setValue(ALLOWED_CERTIFICATES, sb.toString());
    }

    static class Item {
        boolean checked = false;
        String issuedBy;
        String validity;
        String fingerprint;

        Item(boolean checked, String issuedBy, String validity, String fingerprint) {
            this.checked = checked;
            this.issuedBy = issuedBy;
            this.validity = validity;
            this.fingerprint = fingerprint;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Issued By:").append(NL).append('\t').append(this.issuedBy).append(NL);
            sb.append("Validity:").append(NL).append('\t').append(this.validity).append(NL);
            sb.append("SHA1 Fingerprint:").append(NL).append('\t').append(this.fingerprint).append(NL);
            return sb.toString();
        }

        public String getIssuer() {
            return this.issuedBy;
        }

        public String getValidity() {
            return this.validity;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public String toPreferenceValue() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.checked).append(SSLCertificatesPreference.SEPARATOR).append(this.issuedBy).append(SSLCertificatesPreference.SEPARATOR).append(this.validity).append(SSLCertificatesPreference.SEPARATOR).append(this.fingerprint).append(SSLCertificatesPreference.SEPARATOR);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return Objects.equals(this.issuedBy, other.issuedBy) && Objects.equals(this.validity, other.validity) && Objects.equals(this.fingerprint, other.fingerprint);
        }
    }
}

